/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;

class USymbolFolder
extends USymbol {
    private static final int marginTitleX1 = 3;
    private static final int marginTitleX2 = 3;
    private static final int marginTitleX3 = 7;
    private static final int marginTitleY0 = 0;
    private static final int marginTitleY1 = 3;
    private static final int marginTitleY2 = 3;

    USymbolFolder() {
    }

    private void drawFolder(UGraphic uGraphic, double d, double d2, double d3, double d4, Dimension2D dimension2D, boolean bl) {
        double d5 = dimension2D.getWidth() == 0.0 ? Math.max(30.0, d3 / 4.0) : dimension2D.getWidth() + 3.0 + 3.0;
        double d6 = this.getHTitle(dimension2D);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(d5, 0.0);
        uPolygon.addPoint(d5 + 7.0, d6);
        uPolygon.addPoint(d3, d6);
        uPolygon.addPoint(d3, d4);
        uPolygon.addPoint(0.0, d4);
        uPolygon.addPoint(0.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uPolygon);
        uGraphic.draw(d, d2 + d6, new ULine(d5 + 7.0, 0.0));
    }

    private double getHTitle(Dimension2D dimension2D) {
        double d = dimension2D.getWidth() == 0.0 ? 10.0 : dimension2D.getHeight() + 3.0 + 3.0;
        return d;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 20.0, 13.0, 10.0);
    }

    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                symbolContext.apply(uGraphic);
                USymbolFolder.this.drawFolder(uGraphic, d, d2, dimension2D.getWidth(), dimension2D.getHeight(), new Dimension2DDouble(0.0, 0.0), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolFolder.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignement.CENTER);
                textBlock3.drawU(uGraphic, d + margin.getX1(), d2 + margin.getY1());
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolFolder.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d4, double d22) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                symbolContext.apply(uGraphic);
                Dimension2D dimension2D2 = textBlock.calculateDimension(stringBounder);
                USymbolFolder.this.drawFolder(uGraphic, d4, d22, dimension2D.getWidth(), dimension2D.getHeight(), dimension2D2, symbolContext.isShadowing());
                textBlock.drawU(uGraphic, d4 + 4.0, d22 + 2.0);
                Dimension2D dimension2D3 = textBlock2.calculateDimension(stringBounder);
                double d3 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic, d4 + 4.0 + d3, d22 + 2.0 + USymbolFolder.this.getHTitle(dimension2D2));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }
}

