/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;

class USymbolNode
extends USymbol {
    USymbolNode() {
    }

    private void drawNode(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 10.0);
        uPolygon.addPoint(10.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3, d4 - 10.0);
        uPolygon.addPoint(d3 - 10.0, d4);
        uPolygon.addPoint(0.0, d4);
        uPolygon.addPoint(0.0, 10.0);
        if (bl) {
            uPolygon.setDeltaShadow(2.0);
        }
        uGraphic.draw(d, d2, uPolygon);
        uGraphic.draw(d + d3 - 10.0, d2 + 10.0, new ULine(9.0, -9.0));
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 0.0);
        uPath.lineTo(d3 - 10.0, 0.0);
        uPath.lineTo(d3 - 10.0, d4 - 10.0);
        uGraphic.draw(d, d2 + 10.0, uPath);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                symbolContext.apply(uGraphic);
                USymbolNode.this.drawNode(uGraphic, d, d2, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolNode.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignement.CENTER);
                textBlock3.drawU(uGraphic, d + margin.getX1(), d2 + margin.getY1());
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolNode.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d4, double d22) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                symbolContext.apply(uGraphic);
                USymbolNode.this.drawNode(uGraphic, d4, d22, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                textBlock.drawU(uGraphic, d4 + 3.0, d22 + 13.0);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D2.getWidth()) / 2.0;
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                textBlock2.drawU(uGraphic, d4 + d3, d22 + dimension2D3.getHeight() + 13.0);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }
}

