/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagram;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateEntityObjectMultilines
extends CommandMultilines2<ObjectDiagram> {
    public CommandCreateEntityObjectMultilines(ObjectDiagram objectDiagram) {
        super(objectDiagram, CommandCreateEntityObjectMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(object)\\s+"), new RegexLeaf("NAME", "(?:\"([^\"]+)\"\\s+as\\s+)?([\\p{L}0-9_.]+)"), new RegexLeaf("STEREO", "(?:\\s*(\\<\\<.+\\>\\>))?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*\\{\\s*$"));
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^\\s*\\}\\s*$";
    }

    @Override
    public CommandExecutionResult executeNow(List<String> list) {
        StringUtils.trim(list, true);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        IEntity iEntity = this.executeArg0(regexResult);
        if (iEntity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        for (String string : list.subList(1, list.size() - 1)) {
            assert (string.length() > 0);
            if (VisibilityModifier.isVisibilityCharacter(string.charAt(0))) {
                ((ObjectDiagram)this.getSystem()).setVisibilityModifierPresent(true);
            }
            iEntity.addFieldOrMethod(string);
        }
        return CommandExecutionResult.ok();
    }

    private IEntity executeArg0(RegexResult regexResult) {
        Code code = Code.of(regexResult.get("NAME", 1));
        String string = regexResult.get("NAME", 0);
        String string2 = regexResult.get("STEREO", 0);
        if (((ObjectDiagram)this.getSystem()).leafExist(code)) {
            return ((ObjectDiagram)this.getSystem()).getOrCreateLeaf1(code, null);
        }
        ILeaf iLeaf = ((ObjectDiagram)this.getSystem()).createLeaf(code, Display.getWithNewlines(string), LeafType.OBJECT);
        if (string2 != null) {
            iLeaf.setStereotype(new Stereotype(string2, ((ObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((ObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        return iLeaf;
    }
}

