/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.posimo.AbstractEntityImage2;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyX1Y2Y3;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImageClass2
extends AbstractEntityImage2 {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock methods;
    private final TextBlock fields;
    private final CircledCharacter circledCharacter;
    private int xMarginFieldsOrMethod = 5;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;
    private int yMarginCircle = 5;

    public EntityImageClass2(IEntity iEntity, ISkinParam iSkinParam, Collection<Link> collection) {
        super(iEntity, iSkinParam);
        this.name = TextBlockUtils.create(iEntity.getDisplay(), new FontConfiguration(this.getFont(FontParam.CLASS), HtmlColorUtils.BLACK), HorizontalAlignement.CENTER, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(this.getFont(FontParam.CLASS_STEREOTYPE), this.getFontColor(FontParam.CLASS_STEREOTYPE)), HorizontalAlignement.CENTER, iSkinParam);
        this.circledCharacter = this.getCircledCharacter(iEntity);
        throw new UnsupportedOperationException();
    }

    private CircledCharacter getCircledCharacter(IEntity iEntity) {
        Stereotype stereotype = iEntity.getStereotype();
        if (stereotype != null && stereotype.getCharacter() != '\u0000') {
            HtmlColor htmlColor = this.getColor(ColorParam.classBorder);
            UFont uFont = this.getFont(FontParam.CIRCLED_CHARACTER);
            return new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), uFont, stereotype.getHtmlColor(), htmlColor, this.getFontColor(FontParam.CIRCLED_CHARACTER));
        }
        if (iEntity.getEntityType() == LeafType.ABSTRACT_CLASS) {
            return new CircledCharacter('A', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER), this.getColor(ColorParam.stereotypeABackground), this.getColor(ColorParam.classBorder), this.getFontColor(FontParam.CIRCLED_CHARACTER));
        }
        if (iEntity.getEntityType() == LeafType.CLASS) {
            return new CircledCharacter('C', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER), this.getColor(ColorParam.stereotypeCBackground), this.getColor(ColorParam.classBorder), this.getFontColor(FontParam.CIRCLED_CHARACTER));
        }
        if (iEntity.getEntityType() == LeafType.INTERFACE) {
            return new CircledCharacter('I', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER), this.getColor(ColorParam.stereotypeIBackground), this.getColor(ColorParam.classBorder), this.getFontColor(FontParam.CIRCLED_CHARACTER));
        }
        if (iEntity.getEntityType() == LeafType.ENUM) {
            return new CircledCharacter('E', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER), this.getColor(ColorParam.stereotypeEBackground), this.getColor(ColorParam.classBorder), this.getFontColor(FontParam.CIRCLED_CHARACTER));
        }
        assert (false);
        return null;
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTitleDimension(stringBounder);
        Dimension2D dimension2D2 = this.methods.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.fields.calculateDimension(stringBounder);
        double d = Math.max(Math.max(dimension2D2.getWidth() + (double)(2 * this.xMarginFieldsOrMethod), dimension2D3.getWidth() + (double)(2 * this.xMarginFieldsOrMethod)), dimension2D.getWidth() + (double)(2 * this.xMarginCircle));
        double d2 = this.getMethodOrFieldHeight(dimension2D2) + this.getMethodOrFieldHeight(dimension2D3) + dimension2D.getHeight();
        return new Dimension2DDouble(d, d2);
    }

    private double getMethodOrFieldHeight(Dimension2D dimension2D) {
        double d = dimension2D.getHeight();
        if (d == 0.0) {
            return this.marginEmptyFieldsOrMethod;
        }
        return d;
    }

    private Dimension2D getTitleDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getNameAndSteretypeDimension(stringBounder);
        if (this.circledCharacter == null) {
            return dimension2D;
        }
        return new Dimension2DDouble(dimension2D.getWidth() + this.getCircledWidth(stringBounder), Math.max(dimension2D.getHeight(), this.circledCharacter.getPreferredHeight(stringBounder) + (double)(2 * this.yMarginCircle)));
    }

    private Dimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.stereo == null ? new Dimension2DDouble(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(Math.max(dimension2D.getWidth(), dimension2D2.getWidth()), dimension2D.getHeight() + dimension2D2.getHeight());
        return dimension2DDouble;
    }

    private double getCircledWidth(StringBounder stringBounder) {
        if (this.circledCharacter == null) {
            return 0.0;
        }
        return this.circledCharacter.getPreferredWidth(stringBounder) + 3.0;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2, double d3, double d4) {
        ULayoutGroup uLayoutGroup;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.getTitleDimension(stringBounder);
        double d5 = dimension2D.getWidth();
        double d6 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d5, d6);
        uGraphic.getParam().setColor(this.getColor(ColorParam.classBorder));
        uGraphic.getParam().setBackcolor(this.getColor(ColorParam.classBackground));
        double d7 = d;
        double d8 = d2;
        uGraphic.draw(d7, d8, uRectangle);
        if (this.circledCharacter == null) {
            uLayoutGroup = new ULayoutGroup(new PlacementStrategyY1Y2(uGraphic.getStringBounder()));
        } else {
            uLayoutGroup = new ULayoutGroup(new PlacementStrategyX1Y2Y3(uGraphic.getStringBounder()));
            uLayoutGroup.add(this.circledCharacter);
        }
        if (this.stereo != null) {
            uLayoutGroup.add(this.stereo);
        }
        uLayoutGroup.add(this.name);
        uLayoutGroup.drawU(uGraphic, d7, d8, dimension2D.getWidth(), dimension2D2.getHeight());
        d7 = d;
        uGraphic.getParam().setColor(this.getColor(ColorParam.classBorder));
        uGraphic.draw(d7, d8 += dimension2D2.getHeight(), new ULine(d5, 0.0));
        this.fields.drawU(uGraphic, d7 + (double)this.xMarginFieldsOrMethod, d8);
        uGraphic.getParam().setColor(this.getColor(ColorParam.classBorder));
        uGraphic.draw(d7, d8 += this.getMethodOrFieldHeight(this.fields.calculateDimension(stringBounder)), new ULine(d5, 0.0));
        this.methods.drawU(uGraphic, d7 + (double)this.xMarginFieldsOrMethod, d8);
    }
}

