/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.IfManager;
import net.sourceforge.plantuml.preproc.PreprocessorInclude;
import net.sourceforge.plantuml.preproc.ReadLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor
implements ReadLine {
    private static final Pattern definePattern = Pattern.compile("^\\s*!define\\s+([A-Za-z_][A-Za-z_0-9]*(?:\\([A-Za-z_][A-Za-z_0-9]*\\))?)(?:\\s+(.*))?$");
    private static final Pattern undefPattern = Pattern.compile("^\\s*!undef\\s+([A-Za-z_][A-Za-z_0-9]*)$");
    private final Defines defines;
    private final PreprocessorInclude rawSource;
    private final IfManager source;

    public Preprocessor(ReadLine readLine, Defines defines, Set<File> set, File file) {
        this.defines = defines;
        this.rawSource = new PreprocessorInclude(readLine, set, file);
        this.source = new IfManager(this.rawSource, defines);
    }

    @Override
    public String readLine() throws IOException {
        String string = this.source.readLine();
        if (string == null) {
            return null;
        }
        Matcher matcher = definePattern.matcher(string);
        if (matcher.find()) {
            return this.manageDefine(matcher);
        }
        matcher = undefPattern.matcher(string);
        if (matcher.find()) {
            return this.manageUndef(matcher);
        }
        string = this.defines.applyDefines(string);
        return string;
    }

    private String manageUndef(Matcher matcher) throws IOException {
        this.defines.undefine(matcher.group(1));
        return this.readLine();
    }

    private String manageDefine(Matcher matcher) throws IOException {
        this.defines.define(matcher.group(1), matcher.group(2));
        return this.readLine();
    }

    public int getLineNumber() {
        return this.rawSource.getLineNumber();
    }

    @Override
    public void close() throws IOException {
        this.rawSource.close();
    }
}

