/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreprocessorInclude
implements ReadLine {
    private static final Pattern includePattern = Pattern.compile("^\\s*!include\\s+\"?([^\"]+)\"?$");
    private final ReadLine reader2;
    private int numLine = 0;
    private PreprocessorInclude included = null;
    private final File oldCurrentDir;
    private final Set<File> filesUsed;

    public PreprocessorInclude(ReadLine readLine, Set<File> set, File file) {
        this.reader2 = readLine;
        this.filesUsed = set;
        if (file == null) {
            this.oldCurrentDir = null;
        } else {
            this.oldCurrentDir = FileSystem.getInstance().getCurrentDir();
            FileSystem.getInstance().setCurrentDir(file);
        }
    }

    private void restoreCurrentDir() {
        if (this.oldCurrentDir != null) {
            FileSystem.getInstance().setCurrentDir(this.oldCurrentDir);
        }
    }

    @Override
    public String readLine() throws IOException {
        String string;
        if (this.included != null) {
            string = this.included.readLine();
            if (string != null) {
                return string;
            }
            this.included.close();
            this.included = null;
        }
        string = this.reader2.readLine();
        ++this.numLine;
        if (string == null) {
            return null;
        }
        if (OptionFlags.ALLOW_INCLUDE) {
            Matcher matcher = includePattern.matcher(string);
            assert (this.included == null);
            if (matcher.find()) {
                return this.manageInclude(matcher);
            }
        }
        return string;
    }

    private String manageInclude(Matcher matcher) throws IOException {
        File file;
        String string = matcher.group(1);
        int n = string.lastIndexOf(33);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if (!(file = FileSystem.getInstance().getFile(string)).exists()) {
            return "Cannot include " + file.getAbsolutePath();
        }
        this.filesUsed.add(file);
        this.included = new PreprocessorInclude(this.getReaderInclude(file, string2), this.filesUsed, file.getParentFile());
        return this.readLine();
    }

    private ReadLine getReaderInclude(File file, String string) throws IOException {
        if (StartDiagramExtractReader.containsStartDiagram(file)) {
            int n = 0;
            if (string != null && string.matches("\\d+")) {
                n = Integer.parseInt(string);
            }
            return new StartDiagramExtractReader(file, n);
        }
        return new ReadLineReader(new FileReader(file));
    }

    public int getLineNumber() {
        return this.numLine;
    }

    @Override
    public void close() throws IOException {
        this.restoreCurrentDir();
        this.reader2.close();
    }
}

