/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.Knowledge;
import net.sourceforge.plantuml.project2.Task;
import net.sourceforge.plantuml.project2.TaskAttribute;
import net.sourceforge.plantuml.project2.TaskContainer;
import net.sourceforge.plantuml.project2.TaskImpl;
import net.sourceforge.plantuml.project2.TaskMerge;
import net.sourceforge.plantuml.project2.TimeConverter;
import net.sourceforge.plantuml.project2.TimeConverterDay;
import net.sourceforge.plantuml.project2.TimeHeaderDay;
import net.sourceforge.plantuml.project2.TimeHeaderMonth;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.project2.TimeLineDay;
import net.sourceforge.plantuml.project2.Value;
import net.sourceforge.plantuml.project2.ValueInt;
import net.sourceforge.plantuml.project2.ValueTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project2
implements TaskContainer {
    private final TimeLine timeline;
    private final Knowledge knowledge;
    private final List<TaskImpl> tasks = new ArrayList<TaskImpl>();

    public Project2() {
        this.timeline = new TimeLineDay();
        this.knowledge = new Knowledge(this, this.timeline);
    }

    public TimeConverter getTimeConverter(double d) {
        return new TimeConverterDay(this.timeline, this.getStart(), d);
    }

    public Value getExpression(String string) {
        return this.knowledge.evaluate(string);
    }

    public boolean affectation(String string, Value value) {
        int n = string.indexOf(36);
        if (n != -1) {
            return this.affectationTask(string.substring(0, n), string.substring(n + 1), value);
        }
        if (string.startsWith("^")) {
            return this.affectationJalon(string.substring(1), value);
        }
        this.knowledge.set(string, value);
        return true;
    }

    private boolean affectationJalon(String string, Value value) {
        TaskImpl taskImpl = new TaskImpl(this.timeline, string);
        taskImpl.setStart(((ValueTime)value).getValue());
        taskImpl.setDuration(0);
        this.tasks.add(taskImpl);
        this.knowledge.set(string, value);
        return true;
    }

    private boolean affectationTask(String string, String string2, Value value) {
        TaskImpl taskImpl = this.getOrCreateTask(string);
        TaskAttribute taskAttribute = TaskAttribute.fromString(string2);
        if (taskAttribute == TaskAttribute.START) {
            taskImpl.setStart(((ValueTime)value).getValue());
            return true;
        }
        if (taskAttribute == TaskAttribute.DURATION) {
            taskImpl.setDuration(((ValueInt)value).getValue());
            return true;
        }
        if (taskAttribute == TaskAttribute.LOAD) {
            taskImpl.setLoad(((ValueInt)value).getValue());
            return true;
        }
        throw new UnsupportedOperationException();
    }

    private TaskImpl getOrCreateTask(String string) {
        TaskImpl taskImpl = (TaskImpl)this.getTask(string);
        if (taskImpl != null) {
            return taskImpl;
        }
        taskImpl = new TaskImpl(this.timeline, string);
        this.tasks.add(taskImpl);
        return taskImpl;
    }

    public final List<Task> getTasks() {
        ArrayList<TaskImpl> arrayList = new ArrayList<TaskImpl>(this.tasks);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Task getTask(String string) {
        for (TaskImpl object : this.tasks) {
            if (!object.getCode().equals(string)) continue;
            return object;
        }
        Object object = null;
        for (TaskImpl taskImpl : this.tasks) {
            if (!taskImpl.getCode().startsWith(string)) continue;
            if (object == null) {
                object = taskImpl;
                continue;
            }
            object = new TaskMerge(object.getCode(), object.getName(), (Task)object, taskImpl);
        }
        return object;
    }

    public TextBlock getTimeHeader(double d) {
        TimeHeaderDay timeHeaderDay = new TimeHeaderDay(this.getStart(), this.getEnd(), this.timeline, d);
        TimeHeaderMonth timeHeaderMonth = new TimeHeaderMonth(this.getStart(), this.getEnd(), this.timeline, d);
        return TextBlockUtils.mergeTB(timeHeaderMonth, timeHeaderDay, HorizontalAlignement.CENTER);
    }

    private Day getStart() {
        Day day = null;
        for (TaskImpl taskImpl : this.tasks) {
            if (day != null && day.compareTo(taskImpl.getStart()) <= 0) continue;
            day = (Day)taskImpl.getStart();
        }
        return day;
    }

    private Day getEnd() {
        Day day = null;
        for (TaskImpl taskImpl : this.tasks) {
            if (day != null && day.compareTo(taskImpl.getEnd()) >= 0) continue;
            day = (Day)taskImpl.getEnd();
        }
        return day;
    }
}

