/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project2.Row;
import net.sourceforge.plantuml.project2.TimeConverter;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class RowOverwrite
implements Row {
    private final Row r1;
    private final Row r2;

    public RowOverwrite(Row row, Row row2) {
        this.r1 = row;
        this.r2 = row2;
    }

    public TextBlock asTextBloc(final TimeConverter timeConverter) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                double d3 = RowOverwrite.this.getMinXwithoutHeader(timeConverter);
                double d4 = RowOverwrite.this.r1.getMinXwithoutHeader(timeConverter);
                double d5 = RowOverwrite.this.r2.getMinXwithoutHeader(timeConverter);
                RowOverwrite.this.r1.asTextBloc(timeConverter).drawU(uGraphic, d + (d4 - d3), d2);
                RowOverwrite.this.r2.asTextBloc(timeConverter).drawU(uGraphic, d + (d5 - d3), d2);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double d = RowOverwrite.this.getMaxXwithoutHeader(timeConverter) - RowOverwrite.this.getMinXwithoutHeader(timeConverter);
                double d2 = RowOverwrite.this.getHeight();
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public double getMinXwithoutHeader(TimeConverter timeConverter) {
        return Math.min(this.r1.getMinXwithoutHeader(timeConverter), this.r2.getMinXwithoutHeader(timeConverter));
    }

    public double getMaxXwithoutHeader(TimeConverter timeConverter) {
        return Math.max(this.r1.getMaxXwithoutHeader(timeConverter), this.r2.getMaxXwithoutHeader(timeConverter));
    }

    public double getHeight() {
        return Math.max(this.r1.getHeight(), this.r2.getHeight());
    }

    public TextBlock header() {
        return this.r1.header();
    }
}

