/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class Note
implements Event,
SpecificBackcolorable {
    private final Participant p;
    private final Participant p2;
    private final Display strings;
    private final NotePosition position;
    private NoteStyle style = NoteStyle.NORMAL;
    private final Url url;
    private HtmlColor specificBackcolor;

    public Note(Participant participant, NotePosition notePosition, Display display) {
        this(participant, null, notePosition, display);
    }

    public Note(Participant participant, Participant participant2, Display display) {
        this(participant, participant2, NotePosition.OVER_SEVERAL, display);
    }

    private Note(Participant participant, Participant participant2, NotePosition notePosition, Display display) {
        this.p = participant;
        this.p2 = participant2;
        this.position = notePosition;
        if (display != null && display.size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(null, true);
            this.url = urlBuilder.getUrl(((Object)display.get(0)).toString());
        } else {
            this.url = null;
        }
        this.strings = this.url == null ? display : display.subList(1, display.size());
    }

    public Participant getParticipant() {
        return this.p;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    public Display getStrings() {
        return this.strings;
    }

    public NotePosition getPosition() {
        return this.position;
    }

    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    public boolean dealWith(Participant participant) {
        return this.p == participant || this.p2 == participant;
    }

    public Url getUrl() {
        return this.url;
    }

    public final NoteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(NoteStyle noteStyle) {
        this.style = noteStyle;
    }
}

