/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SkinParamBackcoloredReference;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.HSpace;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantEngloberContexted;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.Constraint;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierStack;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierStackImpl;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDelayText;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDivider;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalHSpace;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalNewpage;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalReference;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementElse;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementHeader;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementTail;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.Lazy;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeSegmentVariation;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Message;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1MessageExo;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrawableSetInitializer {
    private ComponentType defaultLineType;
    private final DrawableSet drawableSet;
    private final boolean showTail;
    private double freeX = 0.0;
    private Frontier freeY2 = null;
    private Frontier lastFreeY2 = null;
    private final double autonewpage;
    private ConstraintSet constraintSet;
    private final InGroupablesStack inGroupableStack = new InGroupablesStack();

    public DrawableSetInitializer(Skin skin, ISkinParam iSkinParam, boolean bl, double d) {
        this.drawableSet = new DrawableSet(skin, iSkinParam);
        this.showTail = bl;
        this.autonewpage = d;
    }

    private boolean useContinueLineBecauseOfDelay() {
        String string = this.drawableSet.getSkinParam().getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(string)) {
            return false;
        }
        for (Event event : this.drawableSet.getAllEvents()) {
            if (!(event instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    private ParticipantRange getFullParticipantRange() {
        return new ParticipantRange(0, this.drawableSet.getAllParticipants().size());
    }

    private ParticipantRange getParticipantRange(Event event) {
        return this.getFullParticipantRange();
    }

    private int getParticipantRangeIndex(Participant participant) {
        int n = 0;
        for (Participant participant2 : this.drawableSet.getAllParticipants()) {
            ++n;
            if (participant2 != participant) continue;
            return n;
        }
        throw new IllegalArgumentException();
    }

    public DrawableSet createDrawableSet(StringBounder stringBounder) {
        if (this.freeY2 != null) {
            throw new IllegalStateException();
        }
        this.defaultLineType = this.useContinueLineBecauseOfDelay() ? ComponentType.CONTINUE_LINE : ComponentType.PARTICIPANT_LINE;
        for (Participant iterator : this.drawableSet.getAllParticipants()) {
            this.prepareParticipant(stringBounder, iterator);
        }
        this.lastFreeY2 = this.freeY2 = new FrontierStackImpl(this.drawableSet.getHeadHeight(stringBounder), this.drawableSet.getAllParticipants().size());
        this.drawableSet.setTopStartingY(this.freeY2.getFreeY(this.getFullParticipantRange()));
        for (Participant participant : this.drawableSet.getAllParticipants()) {
            LivingParticipantBox livingParticipantBox = this.drawableSet.getLivingParticipantBox(participant);
            for (int i = 0; i < participant.getInitialLife(); ++i) {
                livingParticipantBox.getLifeLine().addSegmentVariation(LifeSegmentVariation.LARGER, this.freeY2.getFreeY(this.getFullParticipantRange()), participant.getLiveSpecificBackColor());
            }
        }
        ArrayList arrayList = new ArrayList();
        for (LivingParticipantBox livingParticipantBox : this.drawableSet.getAllLivingParticipantBox()) {
            arrayList.add(livingParticipantBox.getParticipantBox());
        }
        this.constraintSet = new ConstraintSet(arrayList, this.freeX);
        for (Event event : new ArrayList<Event>(this.drawableSet.getAllEvents())) {
            ParticipantRange participantRange = this.getParticipantRange(event);
            double d = this.freeY2.getFreeY(participantRange) - this.lastFreeY2.getFreeY(participantRange);
            if (this.autonewpage > 0.0 && d > 0.0 && d + this.getTotalHeight(0.0, stringBounder) > this.autonewpage) {
                this.prepareNewpageSpecial(stringBounder, new Newpage(null), event, participantRange);
            }
            if (event instanceof MessageExo) {
                this.prepareMessageExo(stringBounder, (MessageExo)event, participantRange);
                continue;
            }
            if (event instanceof Message) {
                this.prepareMessage(stringBounder, (Message)event, participantRange);
                continue;
            }
            if (event instanceof Note) {
                this.prepareNote(stringBounder, (Note)event, participantRange);
                continue;
            }
            if (event instanceof LifeEvent) {
                this.prepareLiveEvent(stringBounder, (LifeEvent)event);
                continue;
            }
            if (event instanceof GroupingLeaf) {
                this.prepareGroupingLeaf(stringBounder, (GroupingLeaf)event, participantRange);
                continue;
            }
            if (event instanceof GroupingStart) {
                this.prepareGroupingStart(stringBounder, (GroupingStart)event, participantRange);
                continue;
            }
            if (event instanceof Newpage) {
                this.prepareNewpage(stringBounder, (Newpage)event, participantRange);
                continue;
            }
            if (event instanceof Divider) {
                this.prepareDivider(stringBounder, (Divider)event, participantRange);
                continue;
            }
            if (event instanceof HSpace) {
                this.prepareHSpace(stringBounder, (HSpace)event, participantRange);
                continue;
            }
            if (event instanceof Delay) {
                this.prepareDelay(stringBounder, (Delay)event, arrayList, participantRange);
                continue;
            }
            if (event instanceof Reference) {
                this.prepareReference(stringBounder, (Reference)event, participantRange);
                continue;
            }
            throw new IllegalStateException();
        }
        this.constraintSet.takeConstraintIntoAccount(stringBounder);
        this.takeParticipantEngloberTitleWidth3(stringBounder);
        this.prepareMissingSpace(stringBounder);
        this.drawableSet.setDimension(new Dimension2DDouble(this.freeX, this.getTotalHeight(this.freeY2.getFreeY(this.getFullParticipantRange()), stringBounder)));
        return this.drawableSet;
    }

    private void takeParticipantEngloberTitleWidth3(StringBounder stringBounder) {
        for (ParticipantEngloberContexted participantEngloberContexted : this.drawableSet.getExistingParticipantEnglober()) {
            double d = this.drawableSet.getEngloberPreferedWidth(stringBounder, participantEngloberContexted.getParticipantEnglober());
            ParticipantBox participantBox = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getFirst2()).getParticipantBox();
            ParticipantBox participantBox2 = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getLast2()).getParticipantBox();
            double d2 = this.drawableSet.getX1(participantEngloberContexted);
            double d3 = this.drawableSet.getX2(stringBounder, participantEngloberContexted);
            double d4 = d - (d3 - d2);
            if (!(d4 > 0.0)) continue;
            this.constraintSet.pushToLeftParticipantBox(d4 / 2.0, participantBox, true);
            this.constraintSet.pushToLeftParticipantBox(d4 / 2.0, participantBox2, false);
        }
    }

    private double getTotalHeight(double d, StringBounder stringBounder) {
        return d + this.drawableSet.getTailHeight(stringBounder, this.showTail) + 0.0;
    }

    public double getYposition(StringBounder stringBounder, Newpage newpage) {
        if (newpage == null) {
            throw new IllegalArgumentException();
        }
        GraphicalNewpage graphicalNewpage = (GraphicalNewpage)this.drawableSet.getEvent(newpage);
        return graphicalNewpage.getStartingY();
    }

    private void prepareMissingSpace(StringBounder stringBounder) {
        this.freeX = this.constraintSet.getMaxX();
        double d = 0.0;
        double d2 = 0.0;
        for (GraphicalElement graphicalElement : this.drawableSet.getAllGraphicalElements()) {
            double d3;
            double d4;
            GraphicalElement graphicalElement2;
            double d5;
            if (graphicalElement instanceof GraphicalDelayText) {
                d5 = graphicalElement.getPreferredWidth(stringBounder) - this.freeX;
                if (!(d5 > 0.0)) continue;
                d = Math.max(d, d5 / 2.0);
                d2 = Math.max(d2, d5 / 2.0);
                continue;
            }
            d5 = graphicalElement.getStartingX(stringBounder);
            double d6 = -d5;
            if (d6 > d) {
                d = d6;
            }
            if (graphicalElement instanceof Arrow) {
                Arrow arrow = (Arrow)graphicalElement;
                arrow.setMaxX(this.freeX);
            }
            double d7 = graphicalElement.getPreferredWidth(stringBounder);
            if (graphicalElement instanceof Arrow && d7 < ((Arrow)(graphicalElement2 = (Arrow)graphicalElement)).getActualWidth(stringBounder)) {
                d7 = ((Arrow)graphicalElement2).getActualWidth(stringBounder);
            }
            if (graphicalElement instanceof GroupingGraphicalElementHeader && d7 < ((GroupingGraphicalElement)(graphicalElement2 = (GroupingGraphicalElementHeader)graphicalElement)).getActualWidth(stringBounder)) {
                d7 = ((GroupingGraphicalElement)graphicalElement2).getActualWidth(stringBounder);
            }
            if (!((d4 = (d3 = d5 + d7) - this.freeX) > d2)) continue;
            d2 = d4;
        }
        if (d > 0.0) {
            this.constraintSet.pushToLeft(d);
        }
        this.freeX = this.constraintSet.getMaxX() + d2;
    }

    private void prepareNewpage(StringBounder stringBounder, Newpage newpage, ParticipantRange participantRange) {
        GraphicalNewpage graphicalNewpage = new GraphicalNewpage(this.freeY2.getFreeY(participantRange), this.drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, this.drawableSet.getSkinParam(), null));
        this.lastFreeY2 = this.freeY2;
        this.freeY2 = this.freeY2.add(graphicalNewpage.getPreferredHeight(stringBounder), participantRange);
        this.drawableSet.addEvent(newpage, graphicalNewpage);
    }

    private void prepareNewpageSpecial(StringBounder stringBounder, Newpage newpage, Event event, ParticipantRange participantRange) {
        GraphicalNewpage graphicalNewpage = new GraphicalNewpage(this.freeY2.getFreeY(participantRange), this.drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, this.drawableSet.getSkinParam(), null));
        this.lastFreeY2 = this.freeY2;
        this.freeY2 = this.freeY2.add(graphicalNewpage.getPreferredHeight(stringBounder), participantRange);
        this.drawableSet.addEvent(newpage, graphicalNewpage, event);
    }

    private void prepareDivider(StringBounder stringBounder, Divider divider, ParticipantRange participantRange) {
        GraphicalDivider graphicalDivider = new GraphicalDivider(this.freeY2.getFreeY(participantRange), this.drawableSet.getSkin().createComponent(ComponentType.DIVIDER, null, this.drawableSet.getSkinParam(), divider.getText()));
        this.freeY2 = this.freeY2.add(graphicalDivider.getPreferredHeight(stringBounder), participantRange);
        this.drawableSet.addEvent(divider, graphicalDivider);
    }

    private void prepareHSpace(StringBounder stringBounder, HSpace hSpace, ParticipantRange participantRange) {
        GraphicalHSpace graphicalHSpace = new GraphicalHSpace(this.freeY2.getFreeY(participantRange), hSpace.getPixel());
        this.freeY2 = this.freeY2.add(graphicalHSpace.getPreferredHeight(stringBounder), participantRange);
        this.drawableSet.addEvent(hSpace, graphicalHSpace);
    }

    private void prepareDelay(StringBounder stringBounder, Delay delay, List<ParticipantBox> list, ParticipantRange participantRange) {
        Component component = this.drawableSet.getSkin().createComponent(ComponentType.DELAY_TEXT, null, this.drawableSet.getSkinParam(), delay.getText());
        ParticipantBox participantBox = list.get(0);
        ParticipantBox participantBox2 = list.get(list.size() - 1);
        GraphicalDelayText graphicalDelayText = new GraphicalDelayText(this.freeY2.getFreeY(participantRange), component, participantBox, participantBox2);
        for (ParticipantBox participantBox3 : list) {
            participantBox3.addDelay(graphicalDelayText);
        }
        this.freeY2 = this.freeY2.add(graphicalDelayText.getPreferredHeight(stringBounder), participantRange);
        this.drawableSet.addEvent(delay, graphicalDelayText);
    }

    private void prepareGroupingStart(StringBounder stringBounder, GroupingStart groupingStart, ParticipantRange participantRange) {
        if (groupingStart.getType() != GroupingType.START) {
            throw new IllegalStateException();
        }
        SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.drawableSet.getSkinParam(), groupingStart.getBackColorElement(), groupingStart.getBackColorGeneral());
        Component component = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_SPACE, null, skinParamBackcolored, Display.asList(groupingStart.getComment()));
        double d = component.getPreferredHeight(stringBounder);
        this.freeY2 = this.freeY2.add(d, participantRange);
        Display display = groupingStart.getTitle().equals("group") ? Display.asList(groupingStart.getComment()) : Display.asList(groupingStart.getTitle(), groupingStart.getComment());
        Component component2 = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_HEADER, null, skinParamBackcolored, display);
        ParticipantBox participantBox = this.drawableSet.getVeryfirst();
        InGroupableList inGroupableList = new InGroupableList(participantBox, groupingStart, this.freeY2.getFreeY(participantRange));
        this.inGroupableStack.addList(inGroupableList);
        GroupingGraphicalElementHeader groupingGraphicalElementHeader = new GroupingGraphicalElementHeader(this.freeY2.getFreeY(participantRange), component2, inGroupableList);
        inGroupableList.setMinWidth(((GraphicalElement)groupingGraphicalElementHeader).getPreferredWidth(stringBounder));
        this.freeY2 = this.freeY2.add(((GraphicalElement)groupingGraphicalElementHeader).getPreferredHeight(stringBounder), participantRange);
        this.drawableSet.addEvent(groupingStart, groupingGraphicalElementHeader);
        if (groupingStart.isParallel()) {
            this.freeY2 = ((FrontierStack)this.freeY2).openBar();
        }
    }

    private void prepareGroupingLeaf(StringBounder stringBounder, final GroupingLeaf groupingLeaf, ParticipantRange participantRange) {
        GroupingGraphicalElement groupingGraphicalElement;
        SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.drawableSet.getSkinParam(), null, groupingLeaf.getBackColorGeneral());
        if (groupingLeaf.getType() == GroupingType.ELSE) {
            if (groupingLeaf.isParallel()) {
                this.freeY2 = ((FrontierStack)this.freeY2).restore();
            }
            Component component = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_ELSE, null, skinParamBackcolored, Display.asList(groupingLeaf.getComment()));
            Lazy lazy = new Lazy(){

                public double getNow() {
                    GraphicalElement graphicalElement = DrawableSetInitializer.this.drawableSet.getEvent(groupingLeaf.getJustAfter());
                    if (graphicalElement == null) {
                        return 0.0;
                    }
                    return graphicalElement.getStartingY();
                }
            };
            groupingGraphicalElement = new GroupingGraphicalElementElse(this.freeY2.getFreeY(participantRange), component, this.inGroupableStack.getTopGroupingStructure(), groupingLeaf.isParallel(), lazy);
            double d = groupingGraphicalElement.getPreferredHeight(stringBounder);
            this.freeY2 = this.freeY2.add(d, participantRange);
        } else if (groupingLeaf.getType() == GroupingType.END) {
            GroupingGraphicalElementHeader groupingGraphicalElementHeader;
            if (groupingLeaf.isParallel()) {
                this.freeY2 = ((FrontierStack)this.freeY2).closeBar();
            }
            if ((groupingGraphicalElementHeader = (GroupingGraphicalElementHeader)this.drawableSet.getEvent(groupingLeaf.getGroupingStart())) != null) {
                groupingGraphicalElementHeader.setEndY(this.freeY2.getFreeY(participantRange));
            }
            groupingGraphicalElement = new GroupingGraphicalElementTail(this.freeY2.getFreeY(participantRange), this.inGroupableStack.getTopGroupingStructure(), groupingLeaf.isParallel());
            Component component = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_SPACE, null, skinParamBackcolored, Display.asList(groupingLeaf.getComment()));
            double d = component.getPreferredHeight(stringBounder);
            this.freeY2 = this.freeY2.add(d, participantRange);
            this.inGroupableStack.pop();
        } else {
            throw new IllegalStateException();
        }
        this.drawableSet.addEvent(groupingLeaf, groupingGraphicalElement);
    }

    private void prepareNote(StringBounder stringBounder, Note note, ParticipantRange participantRange) {
        Object object;
        Object object2;
        LivingParticipantBox livingParticipantBox = this.drawableSet.getLivingParticipantBox(note.getParticipant());
        if (note.getParticipant2() == null) {
            object2 = null;
        } else {
            object2 = this.drawableSet.getLivingParticipantBox(note.getParticipant2());
            if (livingParticipantBox.getParticipantBox().getCenterX(stringBounder) > ((LivingParticipantBox)object2).getParticipantBox().getCenterX(stringBounder)) {
                object = livingParticipantBox;
                livingParticipantBox = object2;
                object2 = object;
            }
        }
        object = new SkinParamBackcolored(this.drawableSet.getSkinParam(), note.getSpecificBackColor());
        ComponentType componentType = this.getNoteComponentType(note.getStyle());
        NoteBox noteBox = new NoteBox(this.freeY2.getFreeY(participantRange), this.drawableSet.getSkin().createComponent(componentType, null, (ISkinParam)object, note.getStrings()), livingParticipantBox, (LivingParticipantBox)object2, note.getPosition(), note.getUrl());
        this.inGroupableStack.addElement(noteBox);
        this.drawableSet.addEvent(note, noteBox);
        this.freeY2 = this.freeY2.add(noteBox.getPreferredHeight(stringBounder), participantRange);
    }

    private ComponentType getNoteComponentType(NoteStyle noteStyle) {
        if (noteStyle == NoteStyle.HEXAGONAL) {
            return ComponentType.NOTE_HEXAGONAL;
        }
        if (noteStyle == NoteStyle.BOX) {
            return ComponentType.NOTE_BOX;
        }
        return ComponentType.NOTE;
    }

    private void prepareLiveEvent(StringBounder stringBounder, LifeEvent lifeEvent) {
        if (lifeEvent.getType() != LifeEventType.DESTROY && lifeEvent.getType() != LifeEventType.CREATE) {
            throw new IllegalStateException();
        }
    }

    private void prepareMessage(StringBounder stringBounder, Message message, ParticipantRange participantRange) {
        Step1Message step1Message = new Step1Message(participantRange, stringBounder, message, this.drawableSet, this.freeY2);
        this.freeY2 = step1Message.prepareMessage(this.constraintSet, this.inGroupableStack);
    }

    private void prepareReference(StringBounder stringBounder, Reference reference, ParticipantRange participantRange) {
        LivingParticipantBox livingParticipantBox = this.drawableSet.getLivingParticipantBox(this.drawableSet.getFirst(reference.getParticipant()));
        LivingParticipantBox livingParticipantBox2 = this.drawableSet.getLivingParticipantBox(this.drawableSet.getLast(reference.getParticipant()));
        SkinParamBackcoloredReference skinParamBackcoloredReference = new SkinParamBackcoloredReference(this.drawableSet.getSkinParam(), reference.getBackColorElement(), reference.getBackColorGeneral());
        Display display = new Display();
        display = display.add("ref");
        display = display.addAll(reference.getStrings());
        Component component = this.drawableSet.getSkin().createComponent(ComponentType.REFERENCE, null, skinParamBackcoloredReference, display);
        GraphicalReference graphicalReference = new GraphicalReference(this.freeY2.getFreeY(participantRange), component, livingParticipantBox, livingParticipantBox2, reference.getUrl());
        ParticipantBox participantBox = livingParticipantBox.getParticipantBox();
        ParticipantBox participantBox2 = livingParticipantBox2.getParticipantBox();
        double d = graphicalReference.getPreferredWidth(stringBounder) - participantBox.getPreferredWidth(stringBounder) / 2.0 - participantBox2.getPreferredWidth(stringBounder) / 2.0;
        Constraint constraint = livingParticipantBox == livingParticipantBox2 ? this.constraintSet.getConstraintAfter(participantBox) : this.constraintSet.getConstraint(participantBox, participantBox2);
        constraint.ensureValue(d);
        this.inGroupableStack.addElement(graphicalReference);
        this.inGroupableStack.addElement(livingParticipantBox);
        if (livingParticipantBox != livingParticipantBox2) {
            this.inGroupableStack.addElement(livingParticipantBox2);
        }
        this.freeY2 = this.freeY2.add(graphicalReference.getPreferredHeight(stringBounder), participantRange);
        this.drawableSet.addEvent(reference, graphicalReference);
    }

    private void prepareMessageExo(StringBounder stringBounder, MessageExo messageExo, ParticipantRange participantRange) {
        Step1MessageExo step1MessageExo = new Step1MessageExo(participantRange, stringBounder, messageExo, this.drawableSet, this.freeY2);
        this.freeY2 = step1MessageExo.prepareMessage(this.constraintSet, this.inGroupableStack);
    }

    private void prepareParticipant(StringBounder stringBounder, Participant participant) {
        ComponentType componentType;
        ComponentType componentType2;
        if (participant.getType() == ParticipantType.PARTICIPANT) {
            componentType2 = ComponentType.PARTICIPANT_HEAD;
            componentType = ComponentType.PARTICIPANT_TAIL;
        } else if (participant.getType() == ParticipantType.ACTOR) {
            componentType2 = ComponentType.ACTOR_HEAD;
            componentType = ComponentType.ACTOR_TAIL;
        } else if (participant.getType() == ParticipantType.BOUNDARY) {
            componentType2 = ComponentType.BOUNDARY_HEAD;
            componentType = ComponentType.BOUNDARY_TAIL;
        } else if (participant.getType() == ParticipantType.CONTROL) {
            componentType2 = ComponentType.CONTROL_HEAD;
            componentType = ComponentType.CONTROL_TAIL;
        } else if (participant.getType() == ParticipantType.ENTITY) {
            componentType2 = ComponentType.ENTITY_HEAD;
            componentType = ComponentType.ENTITY_TAIL;
        } else {
            throw new IllegalArgumentException();
        }
        SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.drawableSet.getSkinParam(), participant.getSpecificBackColor(), participant.getUrl() != null);
        Component component = this.drawableSet.getSkin().createComponent(componentType2, null, skinParamBackcolored, participant.getDisplay());
        Component component2 = this.drawableSet.getSkin().createComponent(componentType, null, skinParamBackcolored, participant.getDisplay());
        Component component3 = this.drawableSet.getSkin().createComponent(this.defaultLineType, null, this.drawableSet.getSkinParam(), participant.getDisplay());
        Component component4 = this.drawableSet.getSkin().createComponent(ComponentType.DELAY_LINE, null, this.drawableSet.getSkinParam(), participant.getDisplay());
        ParticipantBox participantBox = new ParticipantBox(component, component3, component2, component4, this.freeX, this.drawableSet.getSkinParam().shadowing());
        Component component5 = this.drawableSet.getSkin().createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, this.drawableSet.getSkinParam(), null);
        LifeLine lifeLine = new LifeLine(participantBox, component5.getPreferredWidth(stringBounder), this.drawableSet.getSkinParam().shadowing());
        this.drawableSet.setLivingParticipantBox(participant, new LivingParticipantBox(participantBox, lifeLine));
        this.freeX = participantBox.getMaxX(stringBounder);
    }

    public void addParticipant(Participant participant, ParticipantEnglober participantEnglober) {
        this.drawableSet.addParticipant(participant, participantEnglober);
    }

    public void addEvent(Event event) {
        this.drawableSet.addEvent(event, null);
    }
}

