/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDelayText;
import net.sourceforge.plantuml.sequencediagram.graphic.Pushable;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantBox
implements Pushable {
    private static int CPT = 0;
    private final int outMargin = 5;
    private double startingX;
    private final Component head;
    private final Component line;
    private final Component tail;
    private final Component delayLine;
    private final boolean shadowing;
    private int cpt = CPT++;
    private final List<GraphicalDelayText> delays = new ArrayList<GraphicalDelayText>();

    public ParticipantBox(Component component, Component component2, Component component3, Component component4, double d, boolean bl) {
        this.startingX = d;
        this.head = component;
        this.line = component2;
        this.tail = component3;
        this.delayLine = component4;
        this.shadowing = bl;
    }

    public String toString() {
        return "PB" + this.cpt;
    }

    public double getMinX() {
        return this.startingX + 5.0;
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.startingX + this.head.getPreferredWidth(stringBounder) + 10.0;
    }

    @Override
    public double getCenterX(StringBounder stringBounder) {
        return this.startingX + this.head.getPreferredWidth(stringBounder) / 2.0 + 5.0;
    }

    public double getHeadHeight(StringBounder stringBounder) {
        return this.head.getPreferredHeight(stringBounder) + this.line.getPreferredHeight(stringBounder) / 2.0;
    }

    public double getHeadHeightOnly(StringBounder stringBounder) {
        return this.head.getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.head.getPreferredWidth(stringBounder);
    }

    public double getTailHeight(StringBounder stringBounder) {
        return this.tail.getPreferredHeight(stringBounder) + this.line.getPreferredHeight(stringBounder) / 2.0;
    }

    @Override
    public void pushToLeft(double d) {
        this.startingX += d;
    }

    public void drawHeadTailU(UGraphic uGraphic, double d, boolean bl, double d2) {
        if (d == 0.0) {
            throw new IllegalStateException("setTopStartingY cannot be zero");
        }
        double d3 = uGraphic.getTranslateX();
        double d4 = uGraphic.getTranslateY();
        StringBounder stringBounder = uGraphic.getStringBounder();
        if (bl) {
            double d5 = d - this.head.getPreferredHeight(stringBounder) - this.line.getPreferredHeight(stringBounder) / 2.0;
            uGraphic.translate(this.getMinX(), d5);
            this.head.drawU(uGraphic, new Area(new Dimension2DDouble(this.head.getPreferredWidth(stringBounder), this.head.getPreferredHeight(stringBounder))), new SimpleContext2D(false));
            uGraphic.setTranslate(d3, d4);
        }
        if (d2 > 0.0) {
            uGraphic.translate(this.getMinX(), d2 += this.line.getPreferredHeight(stringBounder) / 2.0 - 1.0);
            this.tail.drawU(uGraphic, new Area(new Dimension2DDouble(this.tail.getPreferredWidth(stringBounder), this.tail.getPreferredHeight(stringBounder))), new SimpleContext2D(false));
            uGraphic.setTranslate(d3, d4);
        }
    }

    public void drawParticipantHead(UGraphic uGraphic) {
        uGraphic.translate(5.0, 0.0);
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.head.drawU(uGraphic, new Area(new Dimension2DDouble(this.head.getPreferredWidth(stringBounder), this.head.getPreferredHeight(stringBounder))), new SimpleContext2D(false));
        uGraphic.translate(-5.0, 0.0);
    }

    public void drawLineU(UGraphic uGraphic, double d, double d2, boolean bl) {
        double d3 = uGraphic.getTranslateX();
        double d4 = uGraphic.getTranslateY();
        uGraphic.translate(this.startingX, 0.0);
        if (this.delays.size() > 0) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            for (GraphicalDelayText graphicalDelayText : this.delays) {
                if (!(graphicalDelayText.getStartingY() >= d)) continue;
                this.drawLine(uGraphic, d, graphicalDelayText.getStartingY(), this.line);
                this.drawLine(uGraphic, graphicalDelayText.getStartingY(), graphicalDelayText.getEndingY(stringBounder), this.delayLine);
                d = graphicalDelayText.getEndingY(stringBounder);
            }
            if (this.delays.get(this.delays.size() - 1).getEndingY(stringBounder) > d) {
                d = this.delays.get(this.delays.size() - 1).getEndingY(stringBounder);
            }
        }
        this.drawLine(uGraphic, d, d2, this.line);
        uGraphic.setTranslate(d3, d4);
    }

    private void drawLine(UGraphic uGraphic, double d, double d2, Component component) {
        double d3 = uGraphic.getTranslateY();
        uGraphic.translate(0.0, d);
        StringBounder stringBounder = uGraphic.getStringBounder();
        component.drawU(uGraphic, new Area(new Dimension2DDouble(this.head.getPreferredWidth(stringBounder) + 10.0, d2 - d)), new SimpleContext2D(false));
        uGraphic.setTranslate(uGraphic.getTranslateX(), d3);
    }

    public double magicMargin(StringBounder stringBounder) {
        return this.line.getPreferredHeight(stringBounder) / 2.0;
    }

    public double getStartingX() {
        return this.startingX;
    }

    public void addDelay(GraphicalDelayText graphicalDelayText) {
        this.delays.add(graphicalDelayText);
    }

    @Override
    public Collection<Segment> getDelays(final StringBounder stringBounder) {
        return new AbstractCollection<Segment>(){

            @Override
            public Iterator<Segment> iterator() {
                return new Iterator<Segment>(){
                    private final Iterator<GraphicalDelayText> it;
                    {
                        this.it = ParticipantBox.this.delays.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Segment next() {
                        GraphicalDelayText graphicalDelayText = this.it.next();
                        return new Segment(graphicalDelayText.getStartingY(), graphicalDelayText.getEndingY(stringBounder));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ParticipantBox.this.delays.size();
            }
        };
    }
}

