/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class CircleInterface
implements UDrawable {
    private final float thickness;
    private final double headDiam;
    private final HtmlColor backgroundColor;
    private final HtmlColor foregroundColor;

    public CircleInterface(HtmlColor htmlColor, HtmlColor htmlColor2) {
        this(htmlColor, htmlColor2, 16.0, 2.0f);
    }

    public CircleInterface(HtmlColor htmlColor, HtmlColor htmlColor2, double d, float f) {
        this.backgroundColor = htmlColor;
        this.foregroundColor = htmlColor2;
        this.headDiam = d;
        this.thickness = f;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setStroke(new UStroke(this.thickness));
        UEllipse uEllipse = new UEllipse(this.headDiam, this.headDiam);
        uGraphic.getParam().setBackcolor(this.backgroundColor);
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.draw(d + (double)this.thickness, d2 + (double)this.thickness, uEllipse);
        uGraphic.getParam().setStroke(new UStroke());
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }
}

