/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ComponentRoseDivider
extends AbstractTextualComponent {
    private final HtmlColor background;
    private final boolean empty;
    private final boolean withShadow;
    private final UStroke stroke;

    public ComponentRoseDivider(HtmlColor htmlColor, UFont uFont, HtmlColor htmlColor2, Display display, SpriteContainer spriteContainer, boolean bl, UStroke uStroke) {
        super(display, htmlColor, uFont, HorizontalAlignement.CENTER, 4, 4, 4, spriteContainer);
        this.background = htmlColor2;
        this.empty = display.get(0).length() == 0;
        this.withShadow = bl;
        this.stroke = uStroke;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextWidth(stringBounder);
        double d2 = this.getTextHeight(stringBounder);
        double d3 = (dimension2D.getWidth() - d - 6.0) / 2.0;
        double d4 = (dimension2D.getHeight() - d2) / 2.0;
        uGraphic.getParam().setColor(this.background);
        uGraphic.getParam().setBackcolor(this.background);
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), 3.0);
        if (this.withShadow) {
            uRectangle.setDeltaShadow(2.0);
        }
        uGraphic.draw(0.0, dimension2D.getHeight() / 2.0 - 1.0, uRectangle);
        uGraphic.getParam().setColor(HtmlColorUtils.BLACK);
        uGraphic.getParam().setStroke(new UStroke(this.stroke.getThickness() / 2.0));
        uGraphic.draw(0.0, dimension2D.getHeight() / 2.0 - 1.0, new ULine(dimension2D.getWidth(), 0.0));
        uGraphic.draw(0.0, dimension2D.getHeight() / 2.0 + 2.0, new ULine(dimension2D.getWidth(), 0.0));
        if (!this.empty) {
            uGraphic.getParam().setColor(HtmlColorUtils.BLACK);
            uGraphic.getParam().setBackcolor(this.background);
            uGraphic.getParam().setStroke(this.stroke);
            URectangle uRectangle2 = new URectangle(d + 6.0, d2);
            if (this.withShadow) {
                uRectangle2.setDeltaShadow(4.0);
            }
            uGraphic.draw(d3, d4, uRectangle2);
            uGraphic.getParam().setStroke(new UStroke());
            textBlock.drawU(uGraphic, d3 + 6.0, d4 + (double)this.getMarginY());
        }
        uGraphic.getParam().setStroke(new UStroke());
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

