/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

public final class ComponentRoseNoteHexagonal
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double deltaShadow;
    private final UStroke stroke;

    public ComponentRoseNoteHexagonal(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, Display display, SpriteContainer spriteContainer, double d, UStroke uStroke) {
        super(display, htmlColor3, uFont, HorizontalAlignement.LEFT, 12, 12, 4, spriteContainer);
        this.back = htmlColor;
        this.foregroundColor = htmlColor2;
        this.deltaShadow = d;
        this.stroke = uStroke;
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    public double getPaddingX() {
        return 5.0;
    }

    public double getPaddingY() {
        return 5.0;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)this.getTextWidth(stringBounder);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(10.0, 0.0);
        uPolygon.addPoint(n2 - 10, 0.0);
        uPolygon.addPoint(n2, n / 2);
        uPolygon.addPoint(n2 - 10, n);
        uPolygon.addPoint(10.0, n);
        uPolygon.addPoint(0.0, n / 2);
        uPolygon.addPoint(10.0, 0.0);
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.getParam().setBackcolor(this.back);
        uPolygon.setDeltaShadow(this.deltaShadow);
        uGraphic.getParam().setStroke(this.stroke);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.getParam().setStroke(new UStroke());
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), this.getMarginY());
    }
}

