/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreatePackageState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreatePackageState(StateDiagram stateDiagram) {
        super(stateDiagram, CommandCreatePackageState.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^state\\s+"), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+)\\s+"), new RegexLeaf("DISPLAY1", "as\\s+\"([^\"]+)\"")), new RegexConcat(new RegexLeaf("DISPLAY2", "(?:\"([^\"]+)\"\\s+as\\s+)?"), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)"))), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+)?"), new RegexLeaf("(?:\\s*\\{|\\s+begin)$"));
    }

    private String getNotNull(RegexResult regexResult, String string, String string2) {
        if (regexResult.get(string, 0) == null) {
            return regexResult.get(string2, 0);
        }
        return regexResult.get(string, 0);
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        Object object;
        String string;
        IGroup iGroup = ((StateDiagram)this.getSystem()).getCurrentGroup();
        Code code = Code.of(this.getNotNull(regexResult, "CODE1", "CODE2"));
        String string2 = this.getNotNull(regexResult, "DISPLAY1", "DISPLAY2");
        if (string2 == null) {
            string2 = code.getCode();
        }
        IGroup iGroup2 = ((StateDiagram)this.getSystem()).getOrCreateGroup(code, Display.getWithNewlines(string2), null, GroupType.STATE, iGroup);
        String string3 = regexResult.get("STEREOTYPE", 0);
        if (string3 != null) {
            iGroup2.setStereotype(new Stereotype(string3));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object = new UrlBuilder(((StateDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true);
            Url url = ((UrlBuilder)object).getUrl(string);
            iGroup2.addUrl(url);
        }
        if (HtmlColorUtils.getColorIfValid((String)(object = regexResult.get("COLOR", 0))) != null) {
            iGroup2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid((String)object));
        }
        return CommandExecutionResult.ok();
    }
}

