/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Control
implements TextBlock {
    private final double margin = 4.0;
    private final double radius = 12.0;
    private final HtmlColor backgroundColor;
    private final HtmlColor foregroundColor;
    private final double thickness;
    private final double deltaShadow;

    public Control(HtmlColor htmlColor, HtmlColor htmlColor2, double d, double d2) {
        this.backgroundColor = htmlColor;
        this.foregroundColor = htmlColor2;
        this.deltaShadow = d;
        this.thickness = d2;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        d += 4.0;
        d2 += 4.0;
        uGraphic.getParam().setStroke(new UStroke(this.thickness));
        uGraphic.getParam().setBackcolor(this.backgroundColor);
        uGraphic.getParam().setColor(this.foregroundColor);
        UEllipse uEllipse = new UEllipse(24.0, 24.0);
        uEllipse.setDeltaShadow(this.deltaShadow);
        uGraphic.draw(d, d2, uEllipse);
        uGraphic.getParam().setStroke(new UStroke());
        uGraphic.getParam().setBackcolor(this.foregroundColor);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(6.0, -5.0);
        uPolygon.addPoint(4.0, 0.0);
        uPolygon.addPoint(6.0, 5.0);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.draw(d + 12.0 - 4.0, d2, uPolygon);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(32.0, 32.0);
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

