/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class DecorateEntityImage
implements IEntityImage {
    private final IEntityImage original;
    private final HorizontalAlignement horizontal1;
    private final TextBlock text1;
    private final HorizontalAlignement horizontal2;
    private final TextBlock text2;
    private double deltaX;
    private double deltaY;

    public DecorateEntityImage(IEntityImage iEntityImage, TextBlock textBlock, HorizontalAlignement horizontalAlignement) {
        this(iEntityImage, textBlock, horizontalAlignement, null, null);
    }

    public DecorateEntityImage(IEntityImage iEntityImage, TextBlock textBlock, HorizontalAlignement horizontalAlignement, TextBlock textBlock2, HorizontalAlignement horizontalAlignement2) {
        this.original = iEntityImage;
        this.horizontal1 = horizontalAlignement;
        this.text1 = textBlock;
        this.horizontal2 = horizontalAlignement2;
        this.text2 = textBlock2;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        double d3;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.original.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.getTextDim(this.text1, stringBounder);
        Dimension2D dimension2D3 = this.getTextDim(this.text2, stringBounder);
        Dimension2D dimension2D4 = this.getDimension(stringBounder);
        double d4 = d2;
        double d5 = d4 + dimension2D2.getHeight();
        double d6 = d5 + dimension2D.getHeight();
        double d7 = (dimension2D4.getWidth() - dimension2D.getWidth()) / 2.0;
        if (this.text1 != null) {
            d3 = this.getTextX(dimension2D2, dimension2D4, this.horizontal1);
            this.text1.drawU(uGraphic, d3, d4);
        }
        this.original.drawU(uGraphic, d7, d5);
        this.deltaX = d7;
        this.deltaY = d5;
        if (this.text2 != null) {
            d3 = this.getTextX(dimension2D3, dimension2D4, this.horizontal2);
            this.text2.drawU(uGraphic, d3, d6);
        }
    }

    private Dimension2D getTextDim(TextBlock textBlock, StringBounder stringBounder) {
        if (textBlock == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return textBlock.calculateDimension(stringBounder);
    }

    private double getTextX(Dimension2D dimension2D, Dimension2D dimension2D2, HorizontalAlignement horizontalAlignement) {
        if (horizontalAlignement == HorizontalAlignement.CENTER) {
            return (dimension2D2.getWidth() - dimension2D.getWidth()) / 2.0;
        }
        if (horizontalAlignement == HorizontalAlignement.LEFT) {
            return 0.0;
        }
        if (horizontalAlignement == HorizontalAlignement.RIGHT) {
            return dimension2D2.getWidth() - dimension2D.getWidth();
        }
        throw new IllegalStateException();
    }

    public HtmlColor getBackcolor() {
        return this.original.getBackcolor();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.original.getDimension(stringBounder);
        Dimension2D dimension2D2 = Dimension2DDouble.mergeTB(this.getTextDim(this.text1, stringBounder), this.getTextDim(this.text2, stringBounder));
        return Dimension2DDouble.mergeTB(dimension2D, dimension2D2);
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    public final double getDeltaX() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaX + ((DecorateEntityImage)this.original).deltaX;
        }
        return this.deltaX;
    }

    public final double getDeltaY() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaY + ((DecorateEntityImage)this.original).deltaY;
        }
        return this.deltaY;
    }

    public boolean isHidden() {
        return this.original.isHidden();
    }
}

