/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public final class InnerActivity
implements IEntityImage {
    private final IEntityImage im;
    private final HtmlColor borderColor;
    private final boolean shadowing;
    private final HtmlColor backColor;
    public static final double THICKNESS_BORDER = 1.5;

    public InnerActivity(IEntityImage iEntityImage, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl) {
        this.im = iEntityImage;
        this.backColor = htmlColor2;
        this.borderColor = htmlColor;
        this.shadowing = bl;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.getDimension(uGraphic.getStringBounder());
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.backColor);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight(), 25.0, 25.0);
        if (this.shadowing) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic.draw(d, d2, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
        this.im.drawU(uGraphic, d, d2);
    }

    public HtmlColor getBackcolor() {
        return this.im.getBackcolor();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.im.getDimension(stringBounder);
        return dimension2D;
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    public boolean isHidden() {
        return this.im.isHidden();
    }
}

