/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;

class ExtremityArrow
extends Extremity
implements UDrawable {
    private UPolygon polygon = new UPolygon();
    private final ULine line;
    private final Point2D contact;

    public ExtremityArrow(Point2D point2D, double d, Point2D point2D2) {
        d = this.manageround(d);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.addPoint(-9.0, -4.0);
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(d + 1.5707963267948966);
        this.polygon = this.polygon.translate(point2D.getX(), point2D.getY());
        this.contact = new Point2D.Double(point2D.getX() - 5.0 * Math.cos(d + 1.5707963267948966), point2D.getY() - 5.0 * Math.sin(d + 1.5707963267948966));
        this.line = new ULine(point2D2.getX() - this.contact.getX(), point2D2.getY() - this.contact.getY());
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setBackcolor(uGraphic.getParam().getColor());
        uGraphic.draw(d, d2, this.polygon);
        if (this.line.getLength() > 2.0) {
            uGraphic.draw(d + this.contact.getX(), d2 + this.contact.getY(), this.line);
        }
        uGraphic.getParam().setBackcolor(null);
    }
}

