/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

class ExtremityCircleConnect
extends Extremity
implements UDrawable {
    private final double px;
    private final double py;
    private final Point2D dest;
    private final double radius = 6.0;
    private final double radius2 = 10.0;
    private final double ortho;

    public ExtremityCircleConnect(Point2D point2D, double d) {
        this.px = point2D.getX() - 6.0;
        this.py = point2D.getY() - 6.0;
        this.dest = new Point2D.Double(point2D.getX(), point2D.getY());
        this.ortho = d;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setBackcolor(HtmlColorUtils.WHITE);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.draw(d + this.dest.getX() - 6.0, d2 + this.dest.getY() - 6.0, new UEllipse(12.0, 12.0));
        double d3 = -this.ortho * 180.0 / Math.PI + 90.0 - 45.0;
        UEllipse uEllipse = new UEllipse(20.0, 20.0, d3, 90.0);
        uGraphic.draw(d + this.dest.getX() - 10.0, d2 + this.dest.getY() - 10.0, uEllipse);
        uGraphic.getParam().setBackcolor(null);
        uGraphic.getParam().setStroke(new UStroke());
    }
}

