/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;

class ExtremityCircleCross
extends Extremity
implements UDrawable {
    private final double px;
    private final double py;
    private final Point2D dest;
    private final double radius = 7.0;

    public ExtremityCircleCross(Point2D point2D) {
        this.px = point2D.getX() - 7.0;
        this.py = point2D.getY() - 7.0;
        this.dest = new Point2D.Double(point2D.getX(), point2D.getY());
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setBackcolor(HtmlColorUtils.WHITE);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.draw(d + this.dest.getX() - 7.0, d2 + this.dest.getY() - 7.0, new UEllipse(14.0, 14.0));
        uGraphic.getParam().setStroke(new UStroke());
        ExtremityCircleCross.drawLine(uGraphic, d, d2, this.getPointOnCircle(0.7853981633974483), this.getPointOnCircle(3.9269908169872414));
        ExtremityCircleCross.drawLine(uGraphic, d, d2, this.getPointOnCircle(-0.7853981633974483), this.getPointOnCircle(2.356194490192345));
        uGraphic.getParam().setBackcolor(null);
    }

    private Point2D getPointOnCircle(double d) {
        double d2 = this.px + 7.0 + 7.0 * Math.cos(d);
        double d3 = this.py + 7.0 + 7.0 * Math.sin(d);
        return new Point2D.Double(d2, d3);
    }

    private static void drawLine(UGraphic uGraphic, double d, double d2, Point2D point2D, Point2D point2D2) {
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D2.getY() - point2D.getY();
        uGraphic.draw(d + point2D.getX(), d2 + point2D.getY(), new ULine(d3, d4));
    }
}

