/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

class ExtremityStateLine1
extends Extremity
implements UDrawable {
    private UPolygon polygon = new UPolygon();
    private final Point2D dest;
    private final double radius = 7.0;
    private final double angle;

    public ExtremityStateLine1(double d, Point2D point2D) {
        this.angle = this.manageround(d);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new Point2D.Double(point2D.getX(), point2D.getY());
        this.polygon.addPoint(-9.0, -4.0);
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(point2D.getX(), point2D.getY());
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setBackcolor(uGraphic.getParam().getColor());
        uGraphic.draw(d - 7.0 * Math.cos(this.angle), d2 - 7.0 * Math.sin(this.angle), this.polygon);
        uGraphic.getParam().setBackcolor(HtmlColorUtils.WHITE);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.draw(d + this.dest.getX() - 7.0, d2 + this.dest.getY() - 7.0, new UEllipse(14.0, 14.0));
        uGraphic.getParam().setStroke(new UStroke());
        ExtremityStateLine1.drawLine(uGraphic, this.getPointOnCircle(d + this.dest.getX(), d2 + this.dest.getY(), 0.7853981633974483), this.getPointOnCircle(d + this.dest.getX(), d2 + this.dest.getY(), 3.9269908169872414));
        ExtremityStateLine1.drawLine(uGraphic, this.getPointOnCircle(d + this.dest.getX(), d2 + this.dest.getY(), -0.7853981633974483), this.getPointOnCircle(d + this.dest.getX(), d2 + this.dest.getY(), 2.356194490192345));
        uGraphic.getParam().setBackcolor(null);
    }

    private Point2D getPointOnCircle(double d, double d2, double d3) {
        double d4 = d + 7.0 * Math.cos(d3);
        double d5 = d2 + 7.0 * Math.sin(d3);
        return new Point2D.Double(d4, d5);
    }

    private static void drawLine(UGraphic uGraphic, Point2D point2D, Point2D point2D2) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        uGraphic.draw(point2D.getX(), point2D.getY(), new ULine(d, d2));
    }
}

