/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.MiddleCircleCircledMode;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

class MiddleCircleCircled
extends Extremity
implements UDrawable {
    private final double angle;
    private final MiddleCircleCircledMode mode;
    private final double radius1 = 6.0;
    private final UEllipse circle = new UEllipse(12.0, 12.0);
    private final double radius2 = 10.0;
    private final UEllipse bigcircle = new UEllipse(20.0, 20.0);

    public MiddleCircleCircled(double d, MiddleCircleCircledMode middleCircleCircledMode) {
        this.angle = d;
        this.mode = middleCircleCircledMode;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        UEllipse uEllipse;
        uGraphic.getParam().setBackcolor(HtmlColorUtils.WHITE);
        if (this.mode == MiddleCircleCircledMode.BOTH) {
            HtmlColor htmlColor = uGraphic.getParam().getColor();
            uGraphic.getParam().setColor(HtmlColorUtils.WHITE);
            uGraphic.draw(d - 10.0, d2 - 10.0, this.bigcircle);
            uGraphic.getParam().setColor(htmlColor);
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        if (this.mode == MiddleCircleCircledMode.MODE1 || this.mode == MiddleCircleCircledMode.BOTH) {
            uEllipse = new UEllipse(20.0, 20.0, this.angle, 90.0);
            uGraphic.draw(d - 10.0 + 0.0, d2 - 10.0 + 0.0, uEllipse);
        }
        if (this.mode == MiddleCircleCircledMode.MODE2 || this.mode == MiddleCircleCircledMode.BOTH) {
            uEllipse = new UEllipse(20.0, 20.0, this.angle + 180.0, 90.0);
            uGraphic.draw(d - 10.0 + 0.0, d2 - 10.0 + 0.0, uEllipse);
        }
        uGraphic.draw(d - 6.0, d2 - 6.0, this.circle);
        uGraphic.getParam().setStroke(new UStroke());
    }
}

