/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageComponent
extends AbstractEntityImage {
    private final TextBlock desc;
    private final List<Url> url;
    private TextBlock stereo = TextBlockUtils.empty(0.0, 0.0);
    private PackageStyle style;
    private USymbol symbol;

    public EntityImageComponent(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        PackageStyle packageStyle = this.style = stereotype == null ? null : stereotype.getPackageStyle();
        if (this.style == null) {
            PackageStyle packageStyle2 = this.style = iSkinParam.useUml2ForComponent() ? PackageStyle.COMPONENT2 : PackageStyle.COMPONENT1;
            if (stereotype != null && stereotype.getLabel() != null) {
                this.stereo = TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, null)), HorizontalAlignement.CENTER, iSkinParam);
            }
        }
        this.symbol = this.getUSymbol();
        this.url = iLeaf.getUrls();
    }

    private USymbol getUSymbol() {
        if (this.style == PackageStyle.NODE) {
            return USymbol.NODE;
        }
        return null;
    }

    private Margin getSuppDimension() {
        if (this.style == PackageStyle.COMPONENT1) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        if (this.style == PackageStyle.COMPONENT2) {
            return new Margin(10.0, 14.0, 16.0, 11.0);
        }
        if (this.style == PackageStyle.NODE) {
            return new Margin(15.0, 25.0, 20.0, 10.0);
        }
        if (this.style == PackageStyle.FOLDER) {
            return new Margin(10.0, 10.0, 15.0, 5.0);
        }
        if (this.style == PackageStyle.RECT) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        if (this.style == PackageStyle.FRAME) {
            return new Margin(10.0, 10.0, 15.0, 5.0);
        }
        if (this.style == PackageStyle.CLOUD) {
            return new Margin(15.0, 15.0, 15.0, 15.0);
        }
        if (this.style == PackageStyle.DATABASE) {
            return new Margin(10.0, 10.0, 25.0, 10.0);
        }
        if (this.style == PackageStyle.STORAGE) {
            return new Margin(15.0, 15.0, 15.0, 15.0);
        }
        if (this.style == PackageStyle.ARTIFACT) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        if (this.style == PackageStyle.AGENT) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        return new Margin(0.0, 0.0, 0.0, 0.0);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.stereo.calculateDimension(stringBounder));
        Margin margin = this.getSuppDimension();
        return Dimension2DDouble.delta(dimension2D, margin.getWidth(), margin.getHeight());
    }

    private void drawStyled(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        this.style.drawU(uGraphic, d, d2, new Dimension2DDouble(d3, d4), null, this.getSkinParam().shadowing());
        uGraphic.getParam().setStroke(new UStroke());
        Dimension2D dimension2D2 = this.getDimension(stringBounder);
        Dimension2D dimension2D3 = this.desc.calculateDimension(stringBounder);
        Dimension2D dimension2D4 = this.stereo.calculateDimension(stringBounder);
        Dimension2D dimension2D5 = Dimension2DDouble.mergeTB(dimension2D4, dimension2D3);
        Margin margin = this.getSuppDimension();
        double d5 = d + margin.x1 + (dimension2D2.getWidth() - margin.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d6 = d2 + margin.y1 + (dimension2D2.getHeight() - margin.getHeight() - dimension2D5.getHeight()) / 2.0;
        this.desc.drawU(uGraphic, d5, d6 + dimension2D4.getHeight());
        double d7 = d + margin.x1 + (dimension2D2.getWidth() - margin.getWidth() - dimension2D4.getWidth()) / 2.0;
        this.stereo.drawU(uGraphic, d7, d6);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        HtmlColor htmlColor;
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        if ((htmlColor = this.getEntity().getSpecificBackColor()) == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor);
        if (this.symbol == null) {
            uGraphic.getParam().setStroke(new UStroke(1.5));
            uGraphic.getParam().setColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentBorder, this.getStereo()));
            this.drawStyled(uGraphic, d, d2);
        } else {
            SymbolContext symbolContext = new SymbolContext(htmlColor, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentBorder, this.getStereo())).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing());
            this.symbol.asSmall(TextBlockUtils.mergeTB(this.desc, this.stereo, HorizontalAlignement.CENTER), null, symbolContext).drawU(uGraphic, d, d2);
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    static class Margin {
        private final double x1;
        private final double x2;
        private final double y1;
        private final double y2;

        private Margin(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.x2 = d2;
            this.y1 = d3;
            this.y2 = d4;
        }

        private double getWidth() {
            return this.x1 + this.x2;
        }

        private double getHeight() {
            return this.y1 + this.y2;
        }
    }
}

