/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageLollipopInterface
extends AbstractEntityImage {
    private static final int SIZE = 10;
    private final TextBlock desc;
    private final List<Url> url;

    public EntityImageLollipopInterface(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.CLASS, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        this.url = iLeaf.getUrls();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(10.0, 10.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        UEllipse uEllipse = new UEllipse(10.0, 10.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo()));
        uGraphic.getParam().setBackcolor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo()));
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        uGraphic.draw(d, d2, uEllipse);
        uGraphic.getParam().setStroke(new UStroke());
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d3 = dimension2D.getWidth();
        double d4 = d + 5.0 - d3 / 2.0;
        double d5 = d2 + 10.0;
        this.desc.drawU(uGraphic, d4, d5);
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE_IN_RECT;
    }

    public int getShield() {
        return 0;
    }
}

