/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.MathUtils;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graph2.GeomUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class EntityImageNote
extends AbstractEntityImage {
    private final int cornersize = 10;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final boolean withShadow;
    private final List<Url> url;
    private final TextBlock textBlock;
    private Dimension2D size;
    private final double delta = 4.0;
    private Line opaleLine;
    private Shape shape;

    public EntityImageNote(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, EntityImageNote.getSkin(iSkinParam, iLeaf));
        this.withShadow = iSkinParam.shadowing();
        Display display = iLeaf.getDisplay();
        Rose rose = new Rose();
        this.noteBackgroundColor = iLeaf.getSpecificBackColor() == null ? rose.getHtmlColor(iSkinParam, ColorParam.noteBackground) : iLeaf.getSpecificBackColor();
        this.borderColor = rose.getHtmlColor(iSkinParam, ColorParam.noteBorder);
        HtmlColor htmlColor = rose.getFontColor(iSkinParam, FontParam.NOTE);
        UFont uFont = iSkinParam.getFont(FontParam.NOTE, null);
        this.textBlock = display.size() == 1 && display.get(0).length() == 0 ? new TextBlockEmpty() : TextBlockUtils.create(display, new FontConfiguration(uFont, htmlColor), HorizontalAlignement.LEFT, iSkinParam);
        for (Url url : this.textBlock.getUrls()) {
            iLeaf.addUrl(url);
        }
        this.url = iLeaf.getUrls();
    }

    private static ISkinParam getSkin(ISkinParam iSkinParam, IEntity iEntity) {
        Stereotype stereotype = iEntity.getStereotype();
        HtmlColor htmlColor = iEntity.getSpecificBackColor();
        if (htmlColor != null) {
            return new SkinParamBackcolored(iSkinParam, htmlColor);
        }
        htmlColor = EntityImageNote.getColorStatic(iSkinParam, ColorParam.noteBackground, stereotype);
        if (htmlColor != null) {
            return new SkinParamBackcolored(iSkinParam, htmlColor);
        }
        return iSkinParam;
    }

    private static HtmlColor getColorStatic(ISkinParam iSkinParam, ColorParam colorParam, Stereotype stereotype) {
        String string = stereotype == null ? null : stereotype.getLabel();
        Rose rose = new Rose();
        return rose.getHtmlColor(iSkinParam, colorParam, string);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder);
        return d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    private Dimension2D getSize(StringBounder stringBounder, TextBlock textBlock) {
        if (this.size == null) {
            this.size = textBlock.calculateDimension(stringBounder);
        }
        return this.size;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getHeight() + 10.0;
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 6.0 + 15.0;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        double d = this.getPreferredHeight(stringBounder);
        double d2 = this.getPreferredWidth(stringBounder);
        return new Dimension2DDouble(d2, d);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        double d3 = uGraphic.getTranslateX();
        double d4 = uGraphic.getTranslateY();
        uGraphic.translate(d, d2);
        if (this.url.size() > 0 && !this.url.get(0).isMember()) {
            uGraphic.startUrl(this.url.get(0));
        }
        if (this.opaleLine == null || !this.opaleLine.isOpale()) {
            this.drawNormal(uGraphic, d, d2);
        } else {
            StringBounder stringBounder = uGraphic.getStringBounder();
            DotPath dotPath = this.opaleLine.getDotPath();
            dotPath.moveSvek(-this.shape.getMinX(), -this.shape.getMinY());
            Point2D point2D = dotPath.getStartPoint();
            Point2D point2D2 = dotPath.getEndPoint();
            double d5 = this.getTextWidth(stringBounder);
            double d6 = this.getTextHeight(stringBounder);
            Point2D.Double double_ = new Point2D.Double(d5 / 2.0, d6 / 2.0);
            if (point2D.distance(double_) > point2D2.distance(double_)) {
                dotPath = dotPath.reverse();
                point2D = dotPath.getStartPoint();
                point2D2 = dotPath.getEndPoint();
            }
            Direction direction = this.getOpaleStrategy(d5, d6, point2D);
            this.drawOpale(uGraphic, d, d2, dotPath, direction);
        }
        if (this.url.size() > 0 && !this.url.get(0).isMember()) {
            uGraphic.closeAction();
        }
        uGraphic.setTranslate(d3, d4);
    }

    private void drawOpale(UGraphic uGraphic, double d, double d2, DotPath dotPath, Direction direction) {
        UPolygon uPolygon;
        StringBounder stringBounder = uGraphic.getStringBounder();
        UPolygon uPolygon2 = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            uPolygon2.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.noteBackgroundColor);
        uGraphic.draw(0.0, 0.0, uPolygon2);
        Point2D point2D = dotPath.getStartPoint();
        Point2D point2D2 = dotPath.getEndPoint();
        if (direction == Direction.LEFT) {
            uPolygon = this.getPolygonLeft(stringBounder, point2D, point2D2, dotPath);
        } else if (direction == Direction.RIGHT) {
            uPolygon = this.getPolygonRight(stringBounder, point2D, point2D2, dotPath);
        } else if (direction == Direction.UP) {
            uPolygon = this.getPolygonUp(stringBounder, point2D, point2D2, dotPath);
        } else if (direction == Direction.DOWN) {
            uPolygon = this.getPolygonDown(stringBounder, point2D, point2D2, dotPath);
        } else {
            throw new IllegalArgumentException();
        }
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.noteBackgroundColor);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.draw(this.getTextWidth(stringBounder) - 10.0, 0.0, new ULine(0.0, 10.0));
        uGraphic.draw(this.getTextWidth(stringBounder), 10.0, new ULine(-10.0, 0.0));
        this.getTextBlock().drawU(uGraphic, 6.0, 5.0);
    }

    private void drawNormal(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        UPolygon uPolygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            uPolygon.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.noteBackgroundColor);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.draw(this.getTextWidth(stringBounder) - 10.0, 0.0, new ULine(0.0, 10.0));
        uGraphic.draw(this.getTextWidth(stringBounder), 10.0, new ULine(-10.0, 0.0));
        this.getTextBlock().drawU(uGraphic, 6.0, 5.0);
    }

    private UPolygon getPolygonNormal(StringBounder stringBounder) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getTextWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonLeft(StringBounder stringBounder, Point2D point2D, Point2D point2D2, DotPath dotPath) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        double d = point2D.getY() - 4.0;
        d = MathUtils.limitation(d, 0.0, this.getTextHeight(stringBounder) - 8.0);
        uPolygon.addPoint(0.0, d);
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(0.0, d + 8.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getTextWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonRight(StringBounder stringBounder, Point2D point2D, Point2D point2D2, DotPath dotPath) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder));
        double d = point2D.getY() - 4.0;
        d = MathUtils.limitation(d, 10.0, this.getTextHeight(stringBounder) - 8.0);
        uPolygon.addPoint(this.getTextWidth(stringBounder), d + 8.0);
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(this.getTextWidth(stringBounder), d);
        uPolygon.addPoint(this.getTextWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getTextWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonUp(StringBounder stringBounder, Point2D point2D, Point2D point2D2, DotPath dotPath) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getTextWidth(stringBounder) - 10.0, 0.0);
        double d = point2D.getX() - 4.0;
        d = MathUtils.limitation(d, 0.0, this.getTextWidth(stringBounder) - 10.0);
        uPolygon.addPoint(d + 8.0, 0.0);
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(d, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonDown(StringBounder stringBounder, Point2D point2D, Point2D point2D2, DotPath dotPath) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        double d = point2D.getX() - 4.0;
        d = MathUtils.limitation(d, 0.0, this.getTextWidth(stringBounder));
        uPolygon.addPoint(d, this.getTextHeight(stringBounder));
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(d + 8.0, this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getTextWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private Direction getOpaleStrategy(double d, double d2, Point2D point2D) {
        double d3 = GeomUtils.getOrthoDistance(new Line2D.Double(d, 0.0, d, d2), point2D);
        double d4 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, d2, d, d2), point2D);
        double d5 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, 0.0, 0.0, d2), point2D);
        double d6 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, 0.0, d, 0.0), point2D);
        if (d5 <= d3 && d5 <= d4 && d5 <= d6) {
            return Direction.LEFT;
        }
        if (d3 <= d4 && d3 <= d5 && d3 <= d6) {
            return Direction.RIGHT;
        }
        if (d6 <= d3 && d6 <= d4 && d6 <= d5) {
            return Direction.UP;
        }
        if (d4 <= d3 && d4 <= d5 && d4 <= d6) {
            return Direction.DOWN;
        }
        return null;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    public void setOpaleLine(Line line, Shape shape) {
        this.opaleLine = line;
        this.shape = shape;
    }
}

