/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImagePseudoState
extends AbstractEntityImage {
    private static final int SIZE = 22;
    private final TextBlock desc;

    public EntityImagePseudoState(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(Display.asList("H"), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(22.0, 22.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        UEllipse uEllipse = new UEllipse(22.0, 22.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo()));
        uGraphic.getParam().setBackcolor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo()));
        uGraphic.draw(d, d2, uEllipse);
        uGraphic.getParam().setStroke(new UStroke());
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        double d5 = d + (22.0 - d3) / 2.0;
        double d6 = d2 + (22.0 - d4) / 2.0;
        this.desc.drawU(uGraphic, d5, d6);
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    public int getShield() {
        return 0;
    }
}

