/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svg;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.Base64Coder;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgGraphics {
    private final Document document;
    private final Element root;
    private final Element defs;
    private final Element gRoot;
    private String fill = "black";
    private String stroke = "black";
    private String strokeWidth = "1";
    private String strokeDasharray = null;
    private final String backcolor;
    private int maxX = 10;
    private int maxY = 10;
    private Element pendingBackground;
    private Map<List<Object>, String> gradients = new HashMap<List<Object>, String>();
    private final List<Element> pendingLink2 = new ArrayList<Element>();
    private StringBuilder currentPath = null;
    private boolean withShadow = false;
    private boolean hidden;

    protected final void ensureVisible(double d, double d2) {
        if (d > (double)this.maxX) {
            this.maxX = (int)(d + 1.0);
        }
        if (d2 > (double)this.maxY) {
            this.maxY = (int)(d2 + 1.0);
        }
    }

    public SvgGraphics() {
        this(null);
    }

    public SvgGraphics(String string) {
        try {
            this.document = this.getDocument();
            this.backcolor = string;
            this.root = this.getRootNode();
            this.defs = this.simpleElement("defs");
            this.gRoot = this.simpleElement("g");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    public void paintBackcolorGradient(ColorMapper colorMapper, HtmlColorGradient htmlColorGradient) {
        String string = this.createSvgGradient(StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor1())), StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor2())), htmlColorGradient.getPolicy());
        this.setFillColor("url(#" + string + ")");
        this.setStrokeColor(null);
        this.pendingBackground = this.createRectangleInternal(0.0, 0.0, 0.0, 0.0);
        this.getG().appendChild(this.pendingBackground);
    }

    private Element simpleElement(String string) {
        Element element = this.document.createElement(string);
        this.root.appendChild(element);
        return element;
    }

    private Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(true);
        return document;
    }

    private Element getRootNode() {
        Element element = this.document.createElement("svg");
        this.document.appendChild(element);
        element.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        element.setAttribute("version", "1.1");
        return element;
    }

    public void svgEllipse(double d, double d2, double d3, double d4, double d5) {
        this.manageShadow(d5);
        if (!this.hidden) {
            Element element = this.document.createElement("ellipse");
            element.setAttribute("cx", SvgGraphics.format(d));
            element.setAttribute("cy", SvgGraphics.format(d2));
            element.setAttribute("rx", SvgGraphics.format(d3));
            element.setAttribute("ry", SvgGraphics.format(d4));
            element.setAttribute("fill", this.fill);
            element.setAttribute("style", this.getStyle());
            if (d5 > 0.0) {
                element.setAttribute("filter", "url(#f1)");
            }
            this.getG().appendChild(element);
        }
        this.ensureVisible(d + d3 + d5 * 2.0, d2 + d4 + d5 * 2.0);
    }

    public void svgArcEllipse(double d, double d2, double d3, double d4, double d5, double d6) {
        if (!this.hidden) {
            String string = "M" + SvgGraphics.format(d3) + "," + SvgGraphics.format(d4) + " A" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " 0 0 0 " + SvgGraphics.format(d5) + " " + SvgGraphics.format(d6);
            Element element = this.document.createElement("path");
            element.setAttribute("d", string);
            element.setAttribute("fill", this.fill);
            element.setAttribute("style", this.getStyle());
            this.getG().appendChild(element);
        }
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public String createSvgGradient(String string, String string2, char c) {
        List<Object> list = Arrays.asList(string, string2, Character.valueOf(c));
        String string3 = this.gradients.get(list);
        if (string3 == null) {
            Element element = this.document.createElement("linearGradient");
            if (c == '|') {
                element.setAttribute("x1", "0%");
                element.setAttribute("y1", "50%");
                element.setAttribute("x2", "100%");
                element.setAttribute("y2", "50%");
            } else if (c == '\\') {
                element.setAttribute("x1", "0%");
                element.setAttribute("y1", "100%");
                element.setAttribute("x2", "100%");
                element.setAttribute("y2", "0%");
            } else if (c == '-') {
                element.setAttribute("x1", "50%");
                element.setAttribute("y1", "0%");
                element.setAttribute("x2", "50%");
                element.setAttribute("y2", "100%");
            } else {
                element.setAttribute("x1", "0%");
                element.setAttribute("y1", "0%");
                element.setAttribute("x2", "100%");
                element.setAttribute("y2", "100%");
            }
            string3 = "gr" + this.gradients.size();
            this.gradients.put(list, string3);
            element.setAttribute("id", string3);
            Element element2 = this.document.createElement("stop");
            element2.setAttribute("stop-color", string);
            element2.setAttribute("offset", "0%");
            Element element3 = this.document.createElement("stop");
            element3.setAttribute("stop-color", string2);
            element3.setAttribute("offset", "100%");
            element.appendChild(element2);
            element.appendChild(element3);
            this.defs.appendChild(element);
        }
        return string3;
    }

    public final void setFillColor(String string) {
        this.fill = string == null ? "none" : string;
    }

    public final void setStrokeColor(String string) {
        this.stroke = string;
    }

    public final void setStrokeWidth(String string, String string2) {
        this.strokeWidth = string;
        this.strokeDasharray = string2;
    }

    public void closeLink() {
        Element element = this.pendingLink2.get(0);
        this.pendingLink2.remove(0);
        this.getG().appendChild(element);
    }

    public void openLink(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.pendingLink2.add(0, this.document.createElement("a"));
        this.pendingLink2.get(0).setAttribute("xlink:href", string);
        if (string2 == null) {
            this.pendingLink2.get(0).setAttribute("xlink:title", string);
        } else {
            this.pendingLink2.get(0).setAttribute("xlink:title", string2);
        }
    }

    public final Element getG() {
        if (this.pendingLink2.size() == 0) {
            return this.gRoot;
        }
        return this.pendingLink2.get(0);
    }

    public void svgRectangle(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.manageShadow(d7);
        if (!this.hidden) {
            Element element = this.createRectangleInternal(d, d2, d3, d4);
            if (d7 > 0.0) {
                element.setAttribute("filter", "url(#f1)");
            }
            if (d5 > 0.0 && d6 > 0.0) {
                element.setAttribute("rx", SvgGraphics.format(d5));
                element.setAttribute("ry", SvgGraphics.format(d6));
            }
            this.getG().appendChild(element);
        }
        this.ensureVisible(d + d3 + 2.0 * d7, d2 + d4 + 2.0 * d7);
    }

    private Element createRectangleInternal(double d, double d2, double d3, double d4) {
        Element element = this.document.createElement("rect");
        element.setAttribute("x", SvgGraphics.format(d));
        element.setAttribute("y", SvgGraphics.format(d2));
        element.setAttribute("width", SvgGraphics.format(d3));
        element.setAttribute("height", SvgGraphics.format(d4));
        element.setAttribute("fill", this.fill);
        element.setAttribute("style", this.getStyle());
        return element;
    }

    public void svgLine(double d, double d2, double d3, double d4, double d5) {
        this.manageShadow(d5);
        if (!this.hidden) {
            Element element = this.document.createElement("line");
            element.setAttribute("x1", SvgGraphics.format(d));
            element.setAttribute("y1", SvgGraphics.format(d2));
            element.setAttribute("x2", SvgGraphics.format(d3));
            element.setAttribute("y2", SvgGraphics.format(d4));
            element.setAttribute("style", this.getStyle());
            if (d5 > 0.0) {
                element.setAttribute("filter", "url(#f1)");
            }
            this.getG().appendChild(element);
        }
        this.ensureVisible(d + 2.0 * d5, d2 + 2.0 * d5);
        this.ensureVisible(d3 + 2.0 * d5, d4 + 2.0 * d5);
    }

    private String getStyle() {
        return this.getStyle(this.strokeWidth);
    }

    private String getStyle(String string) {
        StringBuilder stringBuilder = new StringBuilder("stroke: " + this.stroke + "; stroke-width: " + string + ";");
        if (this.strokeDasharray != null) {
            stringBuilder.append(" stroke-dasharray: " + this.strokeDasharray + ";");
        }
        return stringBuilder.toString();
    }

    public void svgPolygon(double d, double ... dArray) {
        this.manageShadow(d);
        if (!this.hidden) {
            Element element = this.document.createElement("polygon");
            StringBuilder stringBuilder = new StringBuilder();
            for (double d2 : dArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(SvgGraphics.format(d2));
            }
            element.setAttribute("points", stringBuilder.toString());
            element.setAttribute("fill", this.fill);
            element.setAttribute("style", this.getStyle());
            if (d > 0.0) {
                element.setAttribute("filter", "url(#f1)");
            }
            this.getG().appendChild(element);
        }
        for (int i = 0; i < dArray.length; i += 2) {
            this.ensureVisible(dArray[i] + 2.0 * d, dArray[i + 1] + 2.0 * d);
        }
    }

    public void text(String string, double d, double d2, String string2, int n, String string3, String string4, String string5, double d3, Map<String, String> map) {
        if (!this.hidden) {
            Element element = this.document.createElement("text");
            element.setAttribute("x", SvgGraphics.format(d));
            element.setAttribute("y", SvgGraphics.format(d2));
            element.setAttribute("fill", this.fill);
            element.setAttribute("font-size", SvgGraphics.format(n));
            element.setAttribute("lengthAdjust", "spacingAndGlyphs");
            element.setAttribute("textLength", SvgGraphics.format(d3));
            if (string3 != null) {
                element.setAttribute("font-weight", string3);
            }
            if (string4 != null) {
                element.setAttribute("font-style", string4);
            }
            if (string5 != null) {
                element.setAttribute("text-decoration", string5);
            }
            if (string2 != null) {
                element.setAttribute("font-family", string2);
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                element.setAttribute(entry.getKey(), entry.getValue());
            }
            element.setTextContent(string);
            this.getG().appendChild(element);
        }
        this.ensureVisible(d, d2);
        this.ensureVisible(d + d3, d2);
    }

    public final Element getDefs() {
        return this.defs;
    }

    private Transformer getTransformer() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Log.info("TransformerFactory=" + transformerFactory.getClass());
        Transformer transformer = transformerFactory.newTransformer();
        Log.info("Transformer=" + transformer.getClass());
        transformer.setOutputProperty("standalone", "yes");
        return transformer;
    }

    public void createXml(OutputStream outputStream) throws TransformerException {
        DOMSource dOMSource = new DOMSource(this.document);
        String string = "width:" + this.maxX + "px;height:" + this.maxY + "px;";
        if (this.backcolor != null) {
            string = string + "background:" + this.backcolor + ";";
        }
        this.root.setAttribute("style", string);
        this.root.setAttribute("width", SvgGraphics.format(this.maxX) + "pt");
        this.root.setAttribute("height", SvgGraphics.format(this.maxY) + "pt");
        this.root.setAttribute("viewBox", "0 0 " + this.maxX + " " + this.maxY);
        if (this.pendingBackground != null) {
            this.pendingBackground.setAttribute("width", SvgGraphics.format(this.maxX));
            this.pendingBackground.setAttribute("height", SvgGraphics.format(this.maxY));
        }
        StreamResult streamResult = new StreamResult(outputStream);
        this.getTransformer().transform(dOMSource, streamResult);
    }

    public void svgPath(double d, double d2, UPath uPath, double d3) {
        this.manageShadow(d3);
        this.ensureVisible(d, d2);
        StringBuilder stringBuilder = new StringBuilder();
        for (USegment uSegment : uPath) {
            USegmentType uSegmentType = uSegment.getSegmentType();
            double[] dArray = uSegment.getCoord();
            if (uSegmentType == USegmentType.SEG_MOVETO) {
                stringBuilder.append("M" + SvgGraphics.format(dArray[0] + d) + "," + SvgGraphics.format(dArray[1] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_LINETO) {
                stringBuilder.append("L" + SvgGraphics.format(dArray[0] + d) + "," + SvgGraphics.format(dArray[1] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_QUADTO) {
                stringBuilder.append("Q" + SvgGraphics.format(dArray[0] + d) + "," + SvgGraphics.format(dArray[1] + d2) + " " + SvgGraphics.format(dArray[2] + d) + "," + SvgGraphics.format(dArray[3] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                this.ensureVisible(dArray[2] + d + 2.0 * d3, dArray[3] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CUBICTO) {
                stringBuilder.append("C" + SvgGraphics.format(dArray[0] + d) + "," + SvgGraphics.format(dArray[1] + d2) + " " + SvgGraphics.format(dArray[2] + d) + "," + SvgGraphics.format(dArray[3] + d2) + " " + SvgGraphics.format(dArray[4] + d) + "," + SvgGraphics.format(dArray[5] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                this.ensureVisible(dArray[2] + d + 2.0 * d3, dArray[3] + d2 + 2.0 * d3);
                this.ensureVisible(dArray[4] + d + 2.0 * d3, dArray[5] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown " + uSegment);
        }
        if (!this.hidden) {
            Element element = this.document.createElement("path");
            element.setAttribute("d", stringBuilder.toString());
            element.setAttribute("style", this.getStyle());
            element.setAttribute("fill", this.fill);
            if (d3 > 0.0) {
                element.setAttribute("filter", "url(#f1)");
            }
            this.getG().appendChild(element);
        }
    }

    public void newpath() {
        this.currentPath = new StringBuilder();
    }

    public void moveto(double d, double d2) {
        this.currentPath.append("M" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " ");
        this.ensureVisible(d, d2);
    }

    public void lineto(double d, double d2) {
        this.currentPath.append("L" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " ");
        this.ensureVisible(d, d2);
    }

    public void closepath() {
        this.currentPath.append("Z ");
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        this.currentPath.append("C" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " " + SvgGraphics.format(d3) + "," + SvgGraphics.format(d4) + " " + SvgGraphics.format(d5) + "," + SvgGraphics.format(d6) + " ");
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public void quadto(double d, double d2, double d3, double d4) {
        this.currentPath.append("Q" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " " + SvgGraphics.format(d3) + "," + SvgGraphics.format(d4) + " ");
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
    }

    private static String format(double d) {
        return EpsGraphics.format(d);
    }

    public void fill(int n) {
        if (!this.hidden) {
            Element element = this.document.createElement("path");
            element.setAttribute("d", this.currentPath.toString());
            this.getG().appendChild(element);
        }
        this.currentPath = null;
    }

    public void svgImage(BufferedImage bufferedImage, double d, double d2) throws IOException {
        if (!this.hidden) {
            Element element = this.document.createElement("image");
            element.setAttribute("width", SvgGraphics.format(bufferedImage.getWidth()));
            element.setAttribute("height", SvgGraphics.format(bufferedImage.getHeight()));
            element.setAttribute("x", SvgGraphics.format(d));
            element.setAttribute("y", SvgGraphics.format(d2));
            String string = this.toBase64(bufferedImage);
            element.setAttribute("xlink:href", "data:image/png;base64," + string);
            this.getG().appendChild(element);
        }
        this.ensureVisible(d, d2);
        this.ensureVisible(d + (double)bufferedImage.getWidth(), d2 + (double)bufferedImage.getHeight());
    }

    private String toBase64(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new String(Base64Coder.encode(byArray));
    }

    private void manageShadow(double d) {
        if (d != 0.0) {
            if (!this.withShadow) {
                Element element = this.document.createElement("filter");
                element.setAttribute("id", "f1");
                element.setAttribute("x", "-1");
                element.setAttribute("y", "-1");
                element.setAttribute("width", "300%");
                element.setAttribute("height", "300%");
                this.addFilter(element, "feGaussianBlur", "result", "blurOut", "stdDeviation", "2");
                this.addFilter(element, "feColorMatrix", "type", "matrix", "in", "blurOut", "result", "blurOut2", "values", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 .4 0");
                this.addFilter(element, "feOffset", "result", "blurOut3", "in", "blurOut2", "dx", "4", "dy", "4");
                this.addFilter(element, "feBlend", "in", "SourceGraphic", "in2", "blurOut3", "mode", "normal");
                this.defs.appendChild(element);
            }
            this.withShadow = true;
        }
    }

    private void addFilter(Element element, String string, String ... stringArray) {
        Element element2 = this.document.createElement(string);
        for (int i = 0; i < stringArray.length; i += 2) {
            element2.setAttribute(stringArray[i], stringArray[i + 1]);
        }
        element.appendChild(element2);
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }
}

