/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.image.ContainingEllipse;
import net.sourceforge.plantuml.svek.image.Footprint;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockInEllipse
implements TextBlock {
    private final TextBlock text;
    private final ContainingEllipse ellipse;

    public TextBlockInEllipse(TextBlock textBlock, StringBounder stringBounder) {
        this.text = textBlock;
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        double d = dimension2D.getHeight() / dimension2D.getWidth();
        if (d < 0.2) {
            d = 0.2;
        } else if (d > 0.8) {
            d = 0.8;
        }
        Footprint footprint = new Footprint(stringBounder);
        this.ellipse = footprint.getEllipse(textBlock, d);
    }

    public UEllipse getUEllipse() {
        return this.ellipse.asUEllipse().bigger(6.0);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        UEllipse uEllipse = this.getUEllipse();
        Point2D point2D = this.ellipse.getCenter();
        double d3 = uEllipse.getWidth() / 2.0 - point2D.getX();
        double d4 = uEllipse.getHeight() / 2.0 - point2D.getY();
        uGraphic.draw(d, d2, uEllipse);
        this.text.drawU(uGraphic, d + d3, d2 + d4 - 2.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getUEllipse().getDimension();
    }

    @Override
    public List<Url> getUrls() {
        return this.text.getUrls();
    }

    public void setDeltaShadow(double d) {
        this.ellipse.setDeltaShadow(d);
    }
}

