/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UHorizontalLine
implements UShape {
    private final double skipAtStart;
    private final double skipAtEnd;
    private final TextBlock title;
    private final boolean blankTitle;

    private UHorizontalLine() {
        this(0.0, 0.0, null, false);
    }

    public UHorizontalLine(double d, double d2, TextBlock textBlock, boolean bl) {
        this.skipAtEnd = d2;
        this.skipAtStart = d;
        this.title = textBlock;
        this.blankTitle = bl;
    }

    public static UHorizontalLine infinite(double d, double d2) {
        return new UHorizontalLine(d, d2, null, false);
    }

    public static UHorizontalLine infinite(double d, double d2, TextBlock textBlock) {
        return new UHorizontalLine(d, d2, textBlock, false);
    }

    public static UHorizontalLine infinite() {
        return new UHorizontalLine();
    }

    public void drawLine(UGraphic uGraphic, double d, double d2, double d3) {
        double d4 = d2 - d;
        if (this.title == null) {
            uGraphic.draw(d + this.skipAtStart, d3, new ULine(d4 - this.skipAtStart - this.skipAtEnd, 0.0));
            return;
        }
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d5 = (d4 - dimension2D.getWidth()) / 2.0;
        uGraphic.draw(d + this.skipAtStart - 1.0, d3, new ULine(d5 - this.skipAtEnd - this.skipAtEnd, 0.0));
        this.drawTitle(uGraphic, d, d2, d3, false);
        uGraphic.draw(d + this.skipAtStart + d4 - d5, d3, new ULine(d5 - this.skipAtStart - this.skipAtEnd, 0.0));
    }

    public void drawTitle(UGraphic uGraphic, double d, double d2, double d3, boolean bl) {
        if (this.title == null || this.blankTitle) {
            return;
        }
        double d4 = d2 - d;
        HtmlColor htmlColor = uGraphic.getParam().getColor();
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d5 = (d4 - dimension2D.getWidth()) / 2.0;
        double d6 = d + d5;
        double d7 = d3 - dimension2D.getHeight() / 2.0 - 0.5;
        if (bl) {
            uGraphic.draw(d6, d7, new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        }
        this.title.drawU(uGraphic, d6, d7);
        uGraphic.getParam().setColor(htmlColor);
    }

    public UHorizontalLine blankTitle() {
        return new UHorizontalLine(this.skipAtStart, this.skipAtEnd, this.title, true);
    }
}

