/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverEllipseSvg
implements UDriver<SvgGraphics> {
    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UEllipse uEllipse = (UEllipse)uShape;
        double d3 = uEllipse.getWidth();
        double d4 = uEllipse.getHeight();
        String string = uParam.getColor() == null ? "none" : StringUtils.getAsHtml(colorMapper.getMappedColor(uParam.getColor()));
        String string2 = uParam.getBackcolor() == null ? "none" : StringUtils.getAsHtml(colorMapper.getMappedColor(uParam.getBackcolor()));
        svgGraphics.setFillColor(string2);
        svgGraphics.setStrokeColor(string);
        svgGraphics.setStrokeWidth("" + uParam.getStroke().getThickness(), uParam.getStroke().getDasharraySvg());
        double d5 = uEllipse.getStart();
        double d6 = uEllipse.getExtend();
        double d7 = d + d3 / 2.0;
        double d8 = d2 + d4 / 2.0;
        if (d5 == 0.0 && d6 == 0.0) {
            svgGraphics.svgEllipse(d7, d8, d3 / 2.0, d4 / 2.0, uEllipse.getDeltaShadow());
        } else {
            double d9 = d7 + Math.sin((d5 += 90.0) * Math.PI / 180.0) * d3 / 2.0;
            double d10 = d8 + Math.cos(d5 * Math.PI / 180.0) * d4 / 2.0;
            double d11 = d7 + Math.sin((d5 + d6) * Math.PI / 180.0) * d3 / 2.0;
            double d12 = d8 + Math.cos((d5 + d6) * Math.PI / 180.0) * d4 / 2.0;
            svgGraphics.svgArcEllipse(d3 / 2.0, d4 / 2.0, d9, d10, d11, d12);
        }
    }
}

