/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.afterinvocation;

import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.domain.BasePermission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategyImpl;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.acegisecurity.acls.sid.SidRetrievalStrategyImpl;
import org.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.springframework.util.Assert;

public abstract class AbstractAclProvider
implements AfterInvocationProvider {
    private AclService aclService;
    private Class processDomainObjectClass = class$java$lang$Object == null ? (class$java$lang$Object = AbstractAclProvider.class$("java.lang.Object")) : class$java$lang$Object;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    private String processConfigAttribute;
    private Permission[] requirePermission = new Permission[]{BasePermission.READ};
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractAclProvider(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        Assert.hasText((String)processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)aclService, (String)"An AclService is mandatory");
        if (requirePermission == null || requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
        this.aclService = aclService;
        this.processConfigAttribute = processConfigAttribute;
        this.requirePermission = requirePermission;
    }

    protected Class getProcessDomainObjectClass() {
        return this.processDomainObjectClass;
    }

    protected boolean hasPermission(Authentication authentication, Object domainObject) {
        ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
        Sid[] sids = this.sidRetrievalStrategy.getSids(authentication);
        Acl acl = null;
        try {
            acl = this.aclService.readAclById(objectIdentity, sids);
            return acl.isGranted(this.requirePermission, sids, false);
        }
        catch (NotFoundException ignore) {
            return false;
        }
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        Assert.notNull((Object)objectIdentityRetrievalStrategy, (String)"ObjectIdentityRetrievalStrategy required");
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    protected void setProcessConfigAttribute(String processConfigAttribute) {
        Assert.hasText((String)processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        this.processConfigAttribute = processConfigAttribute;
    }

    public void setProcessDomainObjectClass(Class processDomainObjectClass) {
        Assert.notNull((Object)processDomainObjectClass, (String)"processDomainObjectClass cannot be set to null");
        this.processDomainObjectClass = processDomainObjectClass;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, (String)"SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.processConfigAttribute);
    }

    public boolean supports(Class clazz) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

