/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.feature.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

public final class XSLTUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(XSLTUtils.class);

    private XSLTUtils() {
    }

    public static InputStream transform(Templates xsltTemplate, InputStream in) {
        CachedOutputStream out = new CachedOutputStream();
        try {
            XMLStreamReader reader = StaxUtils.createXMLStreamReader(in);
            StaxSource beforeSource = new StaxSource(reader);
            Transformer trans = xsltTemplate.newTransformer();
            trans.transform(beforeSource, new StreamResult(out));
            InputStream inputStream = out.getInputStream();
            return inputStream;
        }
        catch (IOException e) {
            throw new Fault("GET_CACHED_INPUT_STREAM", LOG, (Throwable)e, e.getMessage());
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
            try {
                out.close();
            }
            catch (Exception e) {}
        }
    }

    public static Reader transform(Templates xsltTemplate, Reader inReader) {
        CachedWriter outWriter = new CachedWriter();
        try {
            XMLStreamReader reader = StaxUtils.createXMLStreamReader(inReader);
            StaxSource beforeSource = new StaxSource(reader);
            Transformer trans = xsltTemplate.newTransformer();
            trans.transform(beforeSource, new StreamResult(outWriter));
            Reader reader2 = outWriter.getReader();
            return reader2;
        }
        catch (IOException e) {
            throw new Fault("GET_CACHED_INPUT_STREAM", LOG, (Throwable)e, e.getMessage());
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, e.getMessage());
        }
        finally {
            try {
                inReader.close();
            }
            catch (Exception e) {}
            try {
                outWriter.close();
            }
            catch (Exception e) {}
        }
    }

    public static Document transform(Templates xsltTemplate, Document in) {
        try {
            DOMSource beforeSource = new DOMSource(in);
            Document out = DOMUtils.createDocument();
            Transformer trans = xsltTemplate.newTransformer();
            trans.transform(beforeSource, new DOMResult(out));
            return out;
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, e.getMessage());
        }
    }
}

