/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;

public abstract class AbstractPropertyEnforcerRule
extends AbstractNonCacheableEnforcerRule {
    public String regex = null;
    public String regexMessage = null;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Object propValue = this.resolveValue(helper);
        if (propValue == null) {
            if (this.message == null) {
                this.message = this.getName() + " \"" + this.getPropertyName() + "\" is required for this build.";
            }
            throw new EnforcerRuleException(this.message);
        }
        if (this.regex != null && !propValue.toString().matches(this.regex)) {
            if (this.regexMessage == null) {
                this.regexMessage = this.getName() + " \"" + this.getPropertyName() + "\" evaluates to \"" + propValue + "\".  " + "This does not match the regular expression \"" + this.regex + "\"";
            }
            throw new EnforcerRuleException(this.regexMessage);
        }
    }

    public abstract String getName();

    public abstract String getPropertyName();

    public abstract Object resolveValue(EnforcerRuleHelper var1) throws EnforcerRuleException;
}

