/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.DependencyVersionMap;
import org.apache.maven.enforcer.rules.dependency.ResolveUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;

@Named(value="dependencyConvergence")
public final class DependencyConvergence
extends AbstractStandardEnforcerRule {
    private boolean uniqueVersions;
    private List<String> includes;
    private List<String> excludes;
    private DependencyVersionMap dependencyVersionMap;
    private final ResolveUtil resolveUtil;

    @Inject
    public DependencyConvergence(ResolveUtil resolveUtil) {
        this.resolveUtil = Objects.requireNonNull(resolveUtil);
    }

    public void execute() throws EnforcerRuleException {
        DependencyNode node = this.resolveUtil.resolveTransitiveDependencies(new DependencySelector[]{new DependencySelector(){

            public boolean selectDependency(Dependency dependency) {
                return !dependency.isOptional() && !dependency.getScope().equals("test") && !dependency.getScope().equals("provided");
            }

            public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
                return this;
            }
        }, new ExclusionDependencySelector()});
        this.dependencyVersionMap = new DependencyVersionMap().setUniqueVersions(this.uniqueVersions);
        node.accept((DependencyVisitor)this.dependencyVersionMap);
        ArrayList<String> errorMsgs = new ArrayList<String>(this.getConvergenceErrorMsgs(this.dependencyVersionMap.getConflictedVersionNumbers(this.includes, this.excludes)));
        for (CharSequence charSequence : errorMsgs) {
            this.getLog().warnOrError(charSequence);
        }
        if (errorMsgs.size() > 0) {
            throw new EnforcerRuleException("Failed while enforcing releasability. See above detailed error message.");
        }
    }

    private StringBuilder buildTreeString(DependencyNode node) {
        ArrayList<String> loc = new ArrayList<String>();
        DependencyNode currentNode = node;
        while (currentNode != null) {
            loc.add(ArtifactUtils.toArtifact(currentNode).toString());
            currentNode = this.dependencyVersionMap.getParent(currentNode);
        }
        Collections.reverse(loc);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < loc.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                builder.append("  ");
            }
            builder.append("+-").append((String)loc.get(i)).append(System.lineSeparator());
        }
        return builder;
    }

    private List<String> getConvergenceErrorMsgs(List<List<DependencyNode>> errors) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        for (List<DependencyNode> nodeList : errors) {
            errorMsgs.add(this.buildConvergenceErrorMsg(nodeList));
        }
        return errorMsgs;
    }

    private String buildConvergenceErrorMsg(List<DependencyNode> nodeList) {
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator()).append("Dependency convergence error for ").append(nodeList.get(0).getArtifact().toString()).append(" paths to dependency are:").append(System.lineSeparator());
        if (nodeList.size() > 0) {
            builder.append((CharSequence)this.buildTreeString(nodeList.get(0)));
        }
        for (DependencyNode node : nodeList.subList(1, nodeList.size())) {
            builder.append("and").append(System.lineSeparator()).append((CharSequence)this.buildTreeString(node));
        }
        return builder.toString();
    }

    public String toString() {
        return String.format("DependencyConvergence[includes=%s, excludes=%s, uniqueVersions=%b]", this.includes, this.excludes, this.uniqueVersions);
    }
}

