/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerLogger;
import org.apache.maven.enforcer.rule.api.EnforcerRuleBase;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.internal.EnforcerLoggerError;
import org.apache.maven.plugins.enforcer.internal.EnforcerLoggerWarn;
import org.apache.maven.plugins.enforcer.internal.EnforcerRuleDesc;
import org.apache.maven.plugins.enforcer.internal.EnforcerRuleManagerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;

@Named
@Singleton
public class EnforcerRuleManager {
    private final Provider<MavenSession> sessionProvider;
    private final Provider<MojoExecution> mojoExecutionProvider;
    private final ComponentConfigurator componentConfigurator;
    private final PlexusContainer plexusContainer;

    @Inject
    public EnforcerRuleManager(Provider<MavenSession> sessionProvider, Provider<MojoExecution> mojoExecutionProvider, @Named(value="basic") ComponentConfigurator componentConfigurator, PlexusContainer plexusContainer) {
        this.sessionProvider = Objects.requireNonNull(sessionProvider, "sessionProvider must be not null");
        this.mojoExecutionProvider = Objects.requireNonNull(mojoExecutionProvider, "mojoExecutionProvider must be not null");
        this.componentConfigurator = Objects.requireNonNull(componentConfigurator, "componentConfigurator must be not null");
        this.plexusContainer = Objects.requireNonNull(plexusContainer, "plexusContainer must be not null");
    }

    public List<EnforcerRuleDesc> createRules(PlexusConfiguration rules, Log log) throws EnforcerRuleManagerException {
        ArrayList<EnforcerRuleDesc> result = new ArrayList<EnforcerRuleDesc>();
        if (rules == null || rules.getChildCount() == 0) {
            return result;
        }
        ClassRealm classRealm = ((MojoExecution)this.mojoExecutionProvider.get()).getMojoDescriptor().getPluginDescriptor().getClassRealm();
        PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator((MavenSession)this.sessionProvider.get(), (MojoExecution)this.mojoExecutionProvider.get());
        EnforcerLoggerError enforcerLoggerError = new EnforcerLoggerError(log);
        EnforcerLoggerWarn enforcerLoggerWarn = new EnforcerLoggerWarn(log);
        for (PlexusConfiguration ruleConfig : rules.getChildren()) {
            EnforcerLevel ruleLevel = this.getRuleLevelFromConfig(ruleConfig);
            EnforcerRuleDesc ruleDesc = this.createRuleDesc(ruleConfig.getName(), ruleConfig.getAttribute("implementation"));
            ruleDesc.getRule().setLog((EnforcerLogger)(ruleLevel == EnforcerLevel.ERROR ? enforcerLoggerError : enforcerLoggerWarn));
            if (ruleConfig.getChildCount() > 0) {
                try {
                    this.componentConfigurator.configureComponent((Object)ruleDesc.getRule(), ruleConfig, (ExpressionEvaluator)evaluator, classRealm);
                }
                catch (ComponentConfigurationException e) {
                    throw new EnforcerRuleManagerException(e);
                }
            }
            result.add(ruleDesc);
        }
        return result;
    }

    private EnforcerLevel getRuleLevelFromConfig(PlexusConfiguration ruleConfig) {
        PlexusConfiguration levelConfig = ruleConfig.getChild("level", false);
        String level = Optional.ofNullable(levelConfig).map(PlexusConfiguration::getValue).orElse(EnforcerLevel.ERROR.name());
        return EnforcerLevel.valueOf((String)level);
    }

    private EnforcerRuleDesc createRuleDesc(String name, String implementation) throws EnforcerRuleManagerException {
        String ruleName = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        if (this.plexusContainer.hasComponent(EnforcerRuleBase.class, ruleName)) {
            try {
                return new EnforcerRuleDesc(ruleName, (EnforcerRuleBase)this.plexusContainer.lookup(EnforcerRuleBase.class, ruleName));
            }
            catch (ComponentLookupException e) {
                throw new EnforcerRuleManagerException(e);
            }
        }
        String ruleClass = implementation != null && !implementation.isEmpty() ? implementation : name;
        if (!ruleClass.contains(".")) {
            ruleClass = "org.apache.maven.plugins.enforcer." + Character.toUpperCase(ruleClass.charAt(0)) + ruleClass.substring(1);
        }
        try {
            return new EnforcerRuleDesc(ruleName, (EnforcerRuleBase)Class.forName(ruleClass).newInstance());
        }
        catch (Exception e) {
            throw new EnforcerRuleManagerException("Failed to create enforcer rules with name: " + ruleName + " or for class: " + ruleClass, e);
        }
    }
}

