/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;

public class ScmCheckModificationsPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private Set excludedFiles = new HashSet<String>(Arrays.asList("pom.xml.backup", "pom.xml.tag", "pom.xml.next", "pom.xml.branch", "release.properties", "pom.xml.releaseBackup"));

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        StatusScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        List additionalExcludes = releaseDescriptor.getCheckModificationExcludes();
        if (additionalExcludes != null) {
            int additionalExcludesSize = additionalExcludes.size();
            for (int i1 = 0; i1 < additionalExcludesSize; ++i1) {
                String exclude = (String)additionalExcludes.get(i1);
                this.excludedFiles.add(exclude);
            }
        }
        this.logInfo(relResult, "Verifying that there are no local modifications...");
        this.logInfo(relResult, "  ignoring changes on: " + StringUtils.join((Collection)this.excludedFiles, (String)", "));
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseDescriptor.getScmSourceUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        try {
            result = provider.status(repository, new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory())));
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred during the status check process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to check for local modifications", (ScmResult)result);
        }
        List changedFiles = result.getChangedFiles();
        Iterator i = changedFiles.iterator();
        while (i.hasNext()) {
            ScmFile f = (ScmFile)i.next();
            String fileName = f.getPath().replace('\\', '/');
            if (!this.excludedFiles.contains(fileName = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.length()))) continue;
            i.remove();
        }
        if (!changedFiles.isEmpty()) {
            StringBuffer message = new StringBuffer();
            for (ScmFile file : changedFiles) {
                message.append(file.toString());
                message.append("\n");
            }
            throw new ReleaseFailureException("Cannot prepare the release because you have local modifications : \n" + message);
        }
        relResult.setResultCode(0);
        return relResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }
}

