/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.webdav;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.resource.Resource;

public class PutInputStream
extends FileInputStream {
    private TransferEventSupport eventSupport;
    private TransferEvent event;

    public PutInputStream(File file, Resource resource, Wagon wagon, TransferEventSupport eventSupport) throws FileNotFoundException {
        super(file);
        this.eventSupport = eventSupport;
        this.event = new TransferEvent(wagon, resource, 3, 6);
        this.event.setLocalFile(file);
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        return this.read(buffer);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int retValue = super.read(buffer, offset, length);
        if (retValue > 0) {
            this.event.setTimestamp(System.currentTimeMillis());
            this.eventSupport.fireTransferProgress(this.event, buffer, retValue);
        }
        return retValue;
    }
}

