/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos;

public class MesosNativeLibrary {
    public static final String VERSION = "0.21.1";
    private static boolean loaded = false;

    public static void load(String path) {
        if (loaded) {
            return;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MesosNativeLibrary.class.getClassLoader());
        try {
            if (path != null) {
                System.load(path);
            } else {
                System.loadLibrary("mesos");
            }
        }
        catch (UnsatisfiedLinkError error) {
            System.err.println("Failed to load native Mesos library from " + (path != null ? path : System.getProperty("java.library.path")));
            throw error;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static void load() {
        String path = System.getenv("MESOS_NATIVE_JAVA_LIBRARY");
        if (path == null && (path = System.getenv("MESOS_NATIVE_LIBRARY")) != null) {
            System.out.println("Warning: MESOS_NATIVE_LIBRARY is deprecated, use MESOS_NATIVE_JAVA_LIBRARY instead. Future releases will not support JNI bindings via MESOS_NATIVE_LIBRARY.");
        }
        MesosNativeLibrary.load(path);
    }
}

