/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.kernel.exps.FilterValueImpl;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.exps.Arguments;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;

public class Args
extends AbstractVal
implements Arguments {
    private final Val[] _args;
    private ClassMetaData _meta = null;

    public Args(Val val1, Val val2) {
        this(new Val[]{val1, val2});
    }

    public Args(Val ... values) {
        ArrayList<Val> list = new ArrayList<Val>();
        if (values != null) {
            for (Val v : values) {
                if (v instanceof Args) {
                    list.addAll(Arrays.asList(((Args)v)._args));
                    continue;
                }
                list.add(v);
            }
        }
        this._args = list.toArray(new Val[list.size()]);
    }

    public FilterValue[] newFilterValues(Select sel, ExpContext ctx, ExpState state) {
        ArgsExpState astate = (ArgsExpState)state;
        FilterValue[] filts = new FilterValue[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            filts[i] = new FilterValueImpl(sel, ctx, astate.states[i], this._args[i]);
        }
        return filts;
    }

    public Value[] getValues() {
        return this._args;
    }

    public Val[] getVals() {
        return this._args;
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    public Class getType() {
        return Object[].class;
    }

    public Class[] getTypes() {
        Class[] c = new Class[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            c[i] = this._args[i].getType();
        }
        return c;
    }

    public void setImplicitType(Class type) {
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState[] states = new ExpState[this._args.length];
        Joins joins = null;
        for (int i = 0; i < this._args.length; ++i) {
            states[i] = this._args[i].initialize(sel, ctx, flags);
            joins = joins == null ? states[i].joins : sel.and(joins, states[i].joins);
        }
        return new ArgsExpState(joins, states);
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        ArgsExpState astate = (ArgsExpState)state;
        for (int i = 0; i < this._args.length; ++i) {
            this._args[i].selectColumns(sel, ctx, astate.states[i], pks);
        }
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) {
        return null;
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        ArgsExpState astate = (ArgsExpState)state;
        for (int i = 0; i < this._args.length; ++i) {
            this._args[i].calculateValue(sel, ctx, astate.states[i], null, null);
        }
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 0;
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        ArgsExpState astate = (ArgsExpState)state;
        for (int i = 0; i < this._args.length; ++i) {
            this._args[i].appendTo(sel, ctx, astate.states[i], sql, index);
            if (i >= this._args.length - 1) continue;
            sql.append(", ");
        }
    }

    @Override
    public void appendIsEmpty(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
    }

    @Override
    public void appendIsNotEmpty(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
    }

    @Override
    public void appendSize(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
    }

    @Override
    public void appendIsNull(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
    }

    @Override
    public void appendIsNotNull(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter((Value)this);
        for (int i = 0; i < this._args.length; ++i) {
            this._args[i].acceptVisit(visitor);
        }
        visitor.exit((Value)this);
    }

    @Override
    public int getId() {
        return 9;
    }

    private static class ArgsExpState
    extends ExpState {
        public ExpState[] states;

        public ArgsExpState(Joins joins, ExpState[] states) {
            super(joins);
            this.states = states;
        }
    }
}

