/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.ParseException;
import org.apache.openjpa.lib.util.TypedProperties;
import serp.util.Strings;

public class Options
extends TypedProperties {
    public static Options EMPTY = new EmptyOptions();
    private static Object[][] _primWrappers = new Object[][]{{Boolean.TYPE, Boolean.class, Boolean.FALSE}, {Byte.TYPE, Byte.class, (byte)0}, {Character.TYPE, Character.class, Character.valueOf('\u0000')}, {Double.TYPE, Double.class, 0.0}, {Float.TYPE, Float.class, Float.valueOf(0.0f)}, {Integer.TYPE, Integer.class, 0}, {Long.TYPE, Long.class, 0L}, {Short.TYPE, Short.class, (short)0}};

    public Options() {
    }

    public Options(Properties defaults) {
        super(defaults);
    }

    public String[] setFromCmdLine(String[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        String key = null;
        Object value = null;
        LinkedList<String> remainder = new LinkedList<String>();
        for (int i = 0; i < args.length + 1; ++i) {
            if (i == args.length || args[i].startsWith("-")) {
                if ((key = Options.trimQuote(key)) != null) {
                    if (!StringUtils.isEmpty(value)) {
                        this.setProperty(key, Options.trimQuote(value));
                    } else {
                        this.setProperty(key, "true");
                    }
                }
                if (i == args.length) break;
                key = args[i].substring(1);
                value = null;
                continue;
            }
            if (key != null) {
                this.setProperty(key, Options.trimQuote(args[i]));
                key = null;
                continue;
            }
            remainder.add(args[i]);
        }
        return remainder.toArray(new String[remainder.size()]);
    }

    public Options setInto(Object obj) {
        Map.Entry<Object, Object> entry2 = null;
        if (this.defaults != null) {
            for (Map.Entry<Object, Object> entry2 : this.defaults.entrySet()) {
                if (this.containsKey(entry2.getKey())) continue;
                this.setInto(obj, entry2);
            }
        }
        Options invalidEntries = null;
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            if (this.setInto(obj, e)) continue;
            if (invalidEntries == null) {
                invalidEntries = new Options();
            }
            invalidEntries.put(e.getKey(), e.getValue());
        }
        return invalidEntries == null ? EMPTY : invalidEntries;
    }

    private boolean setInto(Object obj, Map.Entry entry) {
        if (entry.getKey() == null) {
            return false;
        }
        try {
            int i;
            Object[] match = new Object[]{obj, null};
            if (!Options.matchOptionToMember(entry.getKey().toString(), match)) {
                return false;
            }
            Class[] type = Options.getType(match[1]);
            Object[] values = new Object[type.length];
            String[] strValues = entry.getValue() == null ? new String[1] : (values.length == 1 ? new String[]{entry.getValue().toString()} : Strings.split((String)entry.getValue().toString(), (String)",", (int)0));
            for (i = 0; i < strValues.length; ++i) {
                values[i] = this.stringToObject(strValues[i].trim(), type[i]);
            }
            for (i = strValues.length; i < values.length; ++i) {
                values[i] = this.getDefaultValue(type[i]);
            }
            Options.invoke(match[0], match[1], values);
            return true;
        }
        catch (Throwable t) {
            throw new ParseException(obj + "." + entry.getKey() + " = " + entry.getValue(), t);
        }
    }

    private static String trimQuote(String val) {
        if (val != null && val.startsWith("'") && val.endsWith("'")) {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static Collection<String> findOptionsFor(Class<?> type) {
        TreeSet<String> names = new TreeSet<String>();
        Method[] meths = type.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            Class<?>[] params;
            if (!meths[i].getName().startsWith("set") || (params = meths[i].getParameterTypes()).length == 0 || params[0].isArray()) continue;
            names.add(StringUtils.capitalize((String)meths[i].getName().substring(3)));
        }
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            names.add(StringUtils.capitalize((String)fields[i].getName()));
        }
        return names;
    }

    private static boolean matchOptionToMember(String key, Object[] match) throws Exception {
        if (StringUtils.isEmpty((String)key)) {
            return false;
        }
        String[] find = Strings.split((String)key, (String)".", (int)2);
        String base = StringUtils.capitalize((String)find[0]);
        String set = "set" + base;
        String get = "get" + base;
        Class<?> type = match[0].getClass();
        Method[] meths = type.getMethods();
        Method setMeth = null;
        Method getMeth = null;
        for (int i = 0; i < meths.length; ++i) {
            if (meths[i].getName().equals(set)) {
                Class<?>[] params = meths[i].getParameterTypes();
                if (params.length == 0 || params[0].isArray()) continue;
                if (setMeth == null) {
                    setMeth = meths[i];
                    continue;
                }
                if (params.length < setMeth.getParameterTypes().length) {
                    setMeth = meths[i];
                    continue;
                }
                if (params.length != setMeth.getParameterTypes().length || params[0] != String.class) continue;
                setMeth = meths[i];
                continue;
            }
            if (!meths[i].getName().equals(get)) continue;
            getMeth = meths[i];
        }
        AccessibleObject setter = setMeth;
        AccessibleObject getter = getMeth;
        if (setter == null) {
            Field[] fields = type.getFields();
            String uncapBase = StringUtils.uncapitalize((String)find[0]);
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(base) && !fields[i].getName().equals(uncapBase)) continue;
                setter = fields[i];
                getter = fields[i];
                break;
            }
        }
        if (setter == null && getter == null) {
            return false;
        }
        if (find.length > 1) {
            Object inner = null;
            if (getter != null) {
                inner = Options.invoke(match[0], getter, null);
            }
            if (inner == null && setter != null) {
                Class innerType = Options.getType(setter)[0];
                try {
                    inner = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(innerType));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                Options.invoke(match[0], setter, new Object[]{inner});
            }
            match[0] = inner;
            return Options.matchOptionToMember(find[1], match);
        }
        match[1] = setter;
        return match[1] != null;
    }

    private static Class[] getType(Object member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes();
        }
        return new Class[]{((Field)member).getType()};
    }

    private static Object invoke(Object target, Object member, Object[] values) throws Exception {
        if (member instanceof Method) {
            return ((Method)member).invoke(target, values);
        }
        if (values == null || values.length == 0) {
            return ((Field)member).get(target);
        }
        ((Field)member).set(target, values[0]);
        return null;
    }

    private Object stringToObject(String str, Class type) throws Exception {
        if (str == null || type == String.class) {
            return str;
        }
        if (type == Class.class) {
            return Class.forName(str, false, this.getClass().getClassLoader());
        }
        if ((type.isPrimitive() || Number.class.isAssignableFrom(type)) && str.length() > 2 && str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        if (type.isPrimitive()) {
            for (int i = 0; i < _primWrappers.length; ++i) {
                if (type != _primWrappers[i][0]) continue;
                return this.stringToObject(str, (Class)_primWrappers[i][1]);
            }
        }
        Exception err = null;
        try {
            Constructor cons = type.getConstructor(String.class);
            if (type == Boolean.class && "t".equalsIgnoreCase(str)) {
                str = "true";
            }
            return cons.newInstance(str);
        }
        catch (Exception e) {
            err = e;
            Class<?> subType = null;
            try {
                subType = Class.forName(str);
            }
            catch (Exception e2) {
                throw err;
            }
            if (!type.isAssignableFrom(subType)) {
                throw err;
            }
            try {
                return AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(subType));
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
    }

    private Object getDefaultValue(Class type) {
        for (int i = 0; i < _primWrappers.length; ++i) {
            if (_primWrappers[i][0] != type) continue;
            return _primWrappers[i][2];
        }
        return null;
    }

    public boolean getBooleanProperty(String key, String key2, boolean def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        if (val == null) {
            return def;
        }
        return "t".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val);
    }

    public float getFloatProperty(String key, String key2, float def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Float.parseFloat(val);
    }

    public double getDoubleProperty(String key, String key2, double def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Double.parseDouble(val);
    }

    public long getLongProperty(String key, String key2, long def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Long.parseLong(val);
    }

    public int getIntProperty(String key, String key2, int def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Integer.parseInt(val);
    }

    public String getProperty(String key, String key2, String def) {
        String val = this.getProperty(key);
        return val == null ? this.getProperty(key2, def) : val;
    }

    public boolean removeBooleanProperty(String key, String key2, boolean def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        if (val == null) {
            return def;
        }
        return "t".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val);
    }

    public float removeFloatProperty(String key, String key2, float def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Float.parseFloat(val);
    }

    public double removeDoubleProperty(String key, String key2, double def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Double.parseDouble(val);
    }

    public long removeLongProperty(String key, String key2, long def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Long.parseLong(val);
    }

    public int removeIntProperty(String key, String key2, int def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Integer.parseInt(val);
    }

    public String removeProperty(String key, String key2, String def) {
        String val = this.removeProperty(key);
        return val == null ? this.removeProperty(key2, def) : val;
    }

    private static class EmptyOptions
    extends Options {
        private EmptyOptions() {
        }

        @Override
        public Object setProperty(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

