/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.ImageIOUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PDJpeg
extends PDXObjectImage {
    private BufferedImage image = null;
    private static final String JPG = "jpg";
    private static final List<String> DCT_FILTERS = new ArrayList<String>();
    private static final float DEFAULT_COMPRESSION_LEVEL = 0.75f;

    public PDJpeg(PDStream jpeg) {
        super(jpeg, JPG);
    }

    public PDJpeg(PDDocument doc, InputStream is) throws IOException {
        super(new PDStream(doc, is, true), JPG);
        COSStream dic = this.getCOSStream();
        dic.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
        dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dic.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
        this.getRGBImage();
        if (this.image != null) {
            this.setPropertiesFromAWT(this.image);
        }
    }

    private void setPropertiesFromAWT(BufferedImage image) throws IllegalStateException {
        this.setBitsPerComponent(8);
        if (image.getColorModel().getNumComponents() == 3) {
            this.setColorSpace(PDDeviceRGB.INSTANCE);
        } else if (image.getColorModel().getNumComponents() == 1) {
            this.setColorSpace(new PDDeviceGray());
        } else {
            throw new IllegalStateException("");
        }
        this.setHeight(image.getHeight());
        this.setWidth(image.getWidth());
    }

    public PDJpeg(PDDocument doc, BufferedImage bi) throws IOException {
        super(new PDStream(doc), JPG);
        this.createImageStream(doc, bi, 0.75f);
    }

    public PDJpeg(PDDocument doc, BufferedImage bi, float compressionQuality) throws IOException {
        super(new PDStream(doc), JPG);
        this.createImageStream(doc, bi, compressionQuality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImageStream(PDDocument doc, BufferedImage bi, float compressionQuality) throws IOException {
        BufferedImage alphaImage = null;
        if (bi.getColorModel().hasAlpha()) {
            if (bi.getTransparency() == 2) {
                throw new UnsupportedOperationException("BITMASK Transparency JPEG compression is not useful, use PDPixelMap instead");
            }
            alphaImage = this.extractAlphaImage(bi);
            BufferedImage img = new BufferedImage(bi.getWidth(), bi.getHeight(), 1);
            Graphics2D g = img.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)bi, 0, 0, null);
            g.dispose();
            bi = img;
        }
        OutputStream os = this.getCOSStream().createFilteredStream();
        try {
            ImageIOUtil.writeImage(bi, JPG, os, 72, compressionQuality);
            COSStream dic = this.getCOSStream();
            dic.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
            dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
            dic.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
            if (alphaImage != null) {
                PDJpeg alphaPdImage = new PDJpeg(doc, alphaImage, compressionQuality);
                dic.setItem(COSName.SMASK, (COSObjectable)alphaPdImage);
            }
            this.setPropertiesFromAWT(bi);
        }
        finally {
            os.close();
        }
    }

    public BufferedImage getRGBImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        BufferedImage bi = null;
        boolean readError = false;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.removeAllFiltersButDCT(os);
        os.close();
        byte[] img = os.toByteArray();
        PDColorSpace cs = this.getColorSpace();
        try {
            if (cs instanceof PDDeviceCMYK || cs instanceof PDICCBased && cs.getNumberOfComponents() == 4) {
                int transform = this.getApp14AdobeTransform(img);
                if (transform == 0) {
                    bi = this.convertCMYK2RGB(this.readImage(img), cs);
                } else if (transform != 1 && transform == 2) {
                    bi = this.convertYCCK2RGB(this.readImage(img));
                }
            } else if (cs instanceof PDSeparation) {
                bi = this.processTintTransformation(this.readImage(img), ((PDSeparation)cs).getTintTransform(), cs.getJavaColorSpace());
            } else if (cs instanceof PDDeviceN) {
                bi = this.processTintTransformation(this.readImage(img), ((PDDeviceN)cs).getTintTransform(), cs.getJavaColorSpace());
            } else {
                ByteArrayInputStream bai = new ByteArrayInputStream(img);
                bi = ImageIO.read(bai);
            }
        }
        catch (IIOException exception) {
            readError = true;
        }
        if (bi == null && readError) {
            byte[] newImage = this.replaceHeader(img);
            ByteArrayInputStream bai = new ByteArrayInputStream(newImage);
            bi = ImageIO.read(bai);
        }
        this.image = this.applyMasks(bi);
        return this.image;
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        String colorSpaceName = this.getColorSpace().getName();
        if ("DeviceGray".equals(colorSpaceName) || "DeviceRGB".equals(colorSpaceName)) {
            this.removeAllFiltersButDCT(out);
            return;
        }
        this.getRGBImage();
        if (this.image != null) {
            ImageIOUtil.writeImage(this.image, JPG, out);
        }
    }

    private void removeAllFiltersButDCT(OutputStream out) throws IOException {
        int amountRead;
        InputStream data = this.getPDStream().getPartiallyFilteredStream(DCT_FILTERS);
        byte[] buf = new byte[1024];
        while ((amountRead = data.read(buf)) != -1) {
            out.write(buf, 0, amountRead);
        }
        IOUtils.closeQuietly(data);
    }

    private int getHeaderEndPos(byte[] imageAsBytes) {
        for (int i = 0; i < imageAsBytes.length; ++i) {
            byte b = imageAsBytes[i];
            if (b != -37) continue;
            return i - 2;
        }
        return 0;
    }

    private byte[] replaceHeader(byte[] imageAsBytes) {
        int pos = this.getHeaderEndPos(imageAsBytes);
        byte[] header = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 1, 0, 96, 0, 96, 0, 0};
        byte[] newImage = new byte[imageAsBytes.length - pos + header.length - 1];
        System.arraycopy(header, 0, newImage, 0, header.length);
        System.arraycopy(imageAsBytes, pos + 1, newImage, header.length, imageAsBytes.length - pos - 1);
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getApp14AdobeTransform(byte[] bytes) {
        int transformType = 0;
        ImageReader reader = null;
        ImageInputStream input = null;
        try {
            input = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            if (readers == null || !readers.hasNext()) {
                throw new RuntimeException("No ImageReaders found");
            }
            reader = readers.next();
            if (reader == null) {
                throw new RuntimeException("ImageReader is null");
            }
            reader.setInput(input);
            IIOMetadata meta = reader.getImageMetadata(0);
            if (meta != null) {
                Node tree = meta.getAsTree("javax_imageio_jpeg_image_1.0");
                NodeList children = tree.getChildNodes();
                block11: for (int i = 0; i < children.getLength(); ++i) {
                    Node markerSequence = children.item(i);
                    if (!"markerSequence".equals(markerSequence.getNodeName())) continue;
                    NodeList markerSequenceChildren = markerSequence.getChildNodes();
                    for (int j = 0; j < markerSequenceChildren.getLength(); ++j) {
                        Node child = markerSequenceChildren.item(j);
                        if (!"app14Adobe".equals(child.getNodeName()) || !child.hasAttributes()) continue;
                        NamedNodeMap attribs = child.getAttributes();
                        Node transformNode = attribs.getNamedItem("transform");
                        transformType = Integer.parseInt(transformNode.getNodeValue());
                        continue block11;
                    }
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            if (reader != null) {
                reader.dispose();
            }
        }
        return transformType;
    }

    private Raster readImage(byte[] bytes) throws IOException {
        ImageInputStream input = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        if (readers == null || !readers.hasNext()) {
            input.close();
            throw new RuntimeException("No ImageReaders found");
        }
        ImageReader reader = readers.next();
        if (reader == null) {
            throw new RuntimeException("ImageReader is null");
        }
        reader.setInput(input);
        Raster raster = reader.readRaster(0, reader.getDefaultReadParam());
        input.close();
        reader.dispose();
        return raster;
    }

    private BufferedImage convertCMYK2RGB(Raster raster, PDColorSpace colorspace) throws IOException {
        ColorSpace cs = colorspace.getJavaColorSpace();
        int width = raster.getWidth();
        int height = raster.getHeight();
        byte[] rgb = new byte[width * height * 3];
        int rgbIndex = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                float[] srcColorValues = raster.getPixel(j, i, (float[])null);
                int k = 0;
                while (k < 4) {
                    int n = k++;
                    srcColorValues[n] = srcColorValues[n] / 255.0f;
                }
                float[] rgbValues = cs.toRGB(srcColorValues);
                for (int k2 = 0; k2 < 3; ++k2) {
                    rgb[rgbIndex + k2] = (byte)(rgbValues[k2] * 255.0f);
                }
                rgbIndex += 3;
            }
        }
        return this.createRGBBufferedImage(ColorSpace.getInstance(1000), rgb, width, height);
    }

    private BufferedImage convertYCCK2RGB(Raster raster) throws IOException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        byte[] rgb = new byte[width * height * 3];
        int rgbIndex = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                float[] srcColorValues = raster.getPixel(j, i, (float[])null);
                float k = srcColorValues[3];
                float y = srcColorValues[0];
                float c1 = srcColorValues[1];
                float c2 = srcColorValues[2];
                double val = (double)y + 1.402 * (double)(c2 - 128.0f) - (double)k;
                rgb[rgbIndex] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y - 0.34414 * (double)(c1 - 128.0f) - 0.71414 * (double)(c2 - 128.0f) - (double)k;
                rgb[rgbIndex + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y + 1.772 * (double)(c1 - 128.0f) - (double)k;
                rgb[rgbIndex + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                rgbIndex += 3;
            }
        }
        return this.createRGBBufferedImage(ColorSpace.getInstance(1000), rgb, width, height);
    }

    private BufferedImage processTintTransformation(Raster raster, PDFunction function, ColorSpace colorspace) throws IOException {
        int numberOfInputValues = function.getNumberOfInputParameters();
        int numberOfOutputValues = function.getNumberOfOutputParameters();
        int width = raster.getWidth();
        int height = raster.getHeight();
        byte[] rgb = new byte[width * height * numberOfOutputValues];
        int bufferIndex = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                float[] srcColorValues = raster.getPixel(j, i, (float[])null);
                int k = 0;
                while (k < numberOfInputValues) {
                    int n = k++;
                    srcColorValues[n] = srcColorValues[n] / 255.0f;
                }
                float[] convertedValues = function.eval(srcColorValues);
                for (int k2 = 0; k2 < numberOfOutputValues; ++k2) {
                    rgb[bufferIndex + k2] = (byte)(convertedValues[k2] * 255.0f);
                }
                bufferIndex += numberOfOutputValues;
            }
        }
        return this.createRGBBufferedImage(colorspace, rgb, width, height);
    }

    private BufferedImage createRGBBufferedImage(ColorSpace cs, byte[] rgb, int width, int height) {
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
        WritableRaster writeableRaster = ((ColorModel)cm).createCompatibleWritableRaster(width, height);
        DataBufferByte buffer = (DataBufferByte)writeableRaster.getDataBuffer();
        byte[] bufferData = buffer.getData();
        System.arraycopy(rgb, 0, bufferData, 0, rgb.length);
        return new BufferedImage(cm, writeableRaster, true, null);
    }

    public void clear() {
        super.clear();
        this.image = null;
    }

    static {
        DCT_FILTERS.add(COSName.DCT_DECODE.getName());
        DCT_FILTERS.add(COSName.DCT_DECODE_ABBREVIATION.getName());
    }
}

