/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.core.metadata.ShardingTableMetaDataDecorator;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaDataLoader;
import org.apache.shardingsphere.sql.parser.binder.metadata.table.TableMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.table.TableMetaDataLoader;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ShardingSphere-metadata");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int CORES = Runtime.getRuntime().availableProcessors();
    private static final int FUTURE_GET_TIME_OUT_SEC = 5;
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingRule shardingRule;
    private final int maxConnectionsSizePerQuery;
    private final boolean isCheckingMetaData;

    public TableMetaData load(String logicTableName, DatabaseType databaseType) throws SQLException {
        TableRule tableRule = this.shardingRule.getTableRule(logicTableName);
        if (!this.isCheckingMetaData) {
            DataNode dataNode = tableRule.getActualDataNodes().iterator().next();
            return TableMetaDataLoader.load((DataSource)this.dataSourceMap.get(this.shardingRule.getShardingDataSourceNames().getRawMasterDataSourceName(dataNode.getDataSourceName())), (String)dataNode.getTableName(), (String)databaseType.getName());
        }
        Map<String, List<DataNode>> dataNodeGroups = tableRule.getDataNodeGroups();
        HashMap<String, TableMetaData> actualTableMetaDataMap = new HashMap<String, TableMetaData>(dataNodeGroups.size(), 1.0f);
        HashMap<String, Future> tableFutureMap = new HashMap<String, Future>(dataNodeGroups.size(), 1.0f);
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(CORES * 2, dataNodeGroups.size()));
        for (Map.Entry<String, List<DataNode>> entry : dataNodeGroups.entrySet()) {
            for (DataNode each : entry.getValue()) {
                Future<TableMetaData> futures = executorService.submit(() -> this.load(each, databaseType));
                tableFutureMap.put(each.getTableName(), futures);
            }
        }
        tableFutureMap.forEach((key, value) -> {
            try {
                TableMetaData tableMetaData = (TableMetaData)value.get(5L, TimeUnit.SECONDS);
                actualTableMetaDataMap.put((String)key, tableMetaData);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalStateException(String.format("Error while fetching tableMetaData with key= %s and Value=%s", key, value), e);
            }
        });
        executorService.shutdownNow();
        this.checkUniformed(logicTableName, actualTableMetaDataMap);
        return (TableMetaData)actualTableMetaDataMap.values().iterator().next();
    }

    private TableMetaData load(DataNode dataNode, DatabaseType databaseType) {
        try {
            return TableMetaDataLoader.load((DataSource)this.dataSourceMap.get(dataNode.getDataSourceName()), (String)dataNode.getTableName(), (String)databaseType.getName());
        }
        catch (SQLException e) {
            throw new IllegalStateException(String.format("SQLException for DataNode=%s and databaseType=%s", dataNode, databaseType.getName()), e);
        }
    }

    public SchemaMetaData load(DatabaseType databaseType) throws SQLException {
        SchemaMetaData result = this.loadShardingSchemaMetaData(databaseType);
        result.merge(this.loadDefaultSchemaMetaData(databaseType));
        return result;
    }

    private SchemaMetaData loadShardingSchemaMetaData(DatabaseType databaseType) throws SQLException {
        log.info("Loading {} logic tables' meta data.", (Object)this.shardingRule.getTableRules().size());
        HashMap<String, TableMetaData> tableMetaDataMap = new HashMap<String, TableMetaData>(this.shardingRule.getTableRules().size(), 1.0f);
        for (TableRule each : this.shardingRule.getTableRules()) {
            tableMetaDataMap.put(each.getLogicTable(), this.load(each.getLogicTable(), databaseType));
        }
        return new SchemaMetaData(tableMetaDataMap);
    }

    private SchemaMetaData loadDefaultSchemaMetaData(DatabaseType databaseType) throws SQLException {
        Optional<String> actualDefaultDataSourceName = this.shardingRule.findActualDefaultDataSourceName();
        return actualDefaultDataSourceName.isPresent() ? SchemaMetaDataLoader.load((DataSource)this.dataSourceMap.get(actualDefaultDataSourceName.get()), (int)this.maxConnectionsSizePerQuery, (String)databaseType.getName()) : new SchemaMetaData(Collections.emptyMap());
    }

    private void checkUniformed(String logicTableName, Map<String, TableMetaData> actualTableMetaDataMap) {
        ShardingTableMetaDataDecorator decorator = new ShardingTableMetaDataDecorator();
        TableMetaData sample = decorator.decorate(actualTableMetaDataMap.values().iterator().next(), logicTableName, this.shardingRule);
        Collection violations = actualTableMetaDataMap.entrySet().stream().filter(entry -> !sample.equals((Object)decorator.decorate((TableMetaData)entry.getValue(), logicTableName, this.shardingRule))).map(entry -> new TableMetaDataViolation((String)entry.getKey(), (TableMetaData)entry.getValue())).collect(Collectors.toList());
        this.throwExceptionIfNecessary(violations, logicTableName);
    }

    private void throwExceptionIfNecessary(Collection<TableMetaDataViolation> violations, String logicTableName) {
        if (!violations.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Cannot get uniformed table structure for logic table `%s`, it has different meta data of actual tables are as follows:").append(LINE_SEPARATOR);
            for (TableMetaDataViolation each : violations) {
                errorMessage.append("actual table: ").append(each.getActualTableName()).append(", meta data: ").append(each.getTableMetaData()).append(LINE_SEPARATOR);
            }
            throw new ShardingSphereException(errorMessage.toString(), new Object[]{logicTableName});
        }
    }

    @Generated
    public ShardingMetaDataLoader(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, int maxConnectionsSizePerQuery, boolean isCheckingMetaData) {
        this.dataSourceMap = dataSourceMap;
        this.shardingRule = shardingRule;
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
        this.isCheckingMetaData = isCheckingMetaData;
    }

    private final class TableMetaDataViolation {
        private final String actualTableName;
        private final TableMetaData tableMetaData;

        @Generated
        public TableMetaDataViolation(String actualTableName, TableMetaData tableMetaData) {
            this.actualTableName = actualTableName;
            this.tableMetaData = tableMetaData;
        }

        @Generated
        public String getActualTableName() {
            return this.actualTableName;
        }

        @Generated
        public TableMetaData getTableMetaData() {
            return this.tableMetaData;
        }
    }
}

