/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.sql.parser.binder.metadata.column.ColumnMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.index.IndexMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.table.TableMetaData;
import org.apache.shardingsphere.underlying.common.metadata.decorator.TableMetaDataDecorator;
import org.apache.shardingsphere.underlying.common.rule.DataNode;

public final class ShardingTableMetaDataDecorator
implements TableMetaDataDecorator<ShardingRule> {
    public TableMetaData decorate(TableMetaData tableMetaData, String tableName, ShardingRule shardingRule) {
        return shardingRule.findTableRule(tableName).map(tableRule -> new TableMetaData(this.getColumnMetaDataList(tableMetaData, (TableRule)tableRule), this.getIndexMetaDataList(tableMetaData, (TableRule)tableRule))).orElse(tableMetaData);
    }

    private Collection<ColumnMetaData> getColumnMetaDataList(TableMetaData tableMetaData, TableRule tableRule) {
        Optional<String> generateKeyColumn = tableRule.getGenerateKeyColumn();
        if (!generateKeyColumn.isPresent()) {
            return tableMetaData.getColumns().values();
        }
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        for (Map.Entry entry : tableMetaData.getColumns().entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase(generateKeyColumn.get())) {
                result.add(new ColumnMetaData(((ColumnMetaData)entry.getValue()).getName(), ((ColumnMetaData)entry.getValue()).getDataType(), ((ColumnMetaData)entry.getValue()).getDataTypeName(), ((ColumnMetaData)entry.getValue()).isPrimaryKey(), true, ((ColumnMetaData)entry.getValue()).isCaseSensitive()));
                continue;
            }
            result.add((ColumnMetaData)entry.getValue());
        }
        return result;
    }

    private Collection<IndexMetaData> getIndexMetaDataList(TableMetaData tableMetaData, TableRule tableRule) {
        HashSet<IndexMetaData> result = new HashSet<IndexMetaData>();
        for (Map.Entry entry : tableMetaData.getIndexes().entrySet()) {
            for (DataNode each : tableRule.getActualDataNodes()) {
                this.getLogicIndex((String)entry.getKey(), each.getTableName()).ifPresent(logicIndex -> result.add(new IndexMetaData(logicIndex)));
            }
        }
        return result;
    }

    private Optional<String> getLogicIndex(String actualIndexName, String actualTableName) {
        String indexNameSuffix = "_" + actualTableName;
        return actualIndexName.endsWith(indexNameSuffix) ? Optional.of(actualIndexName.replace(indexNameSuffix, "")) : Optional.empty();
    }
}

