/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rule;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.underlying.common.config.exception.ShardingSphereConfigurationException;

public final class BindingTableRule {
    private final List<TableRule> tableRules;

    public boolean hasLogicTable(String logicTable) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equals(logicTable.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String getBindingActualTable(String dataSource, String logicTable, String otherActualTable) {
        TableRule each2;
        int index = -1;
        Iterator<TableRule> iterator = this.tableRules.iterator();
        while (iterator.hasNext() && -1 == (index = (each2 = iterator.next()).findActualTableIndex(dataSource, otherActualTable))) {
        }
        if (-1 == index) {
            throw new ShardingSphereConfigurationException("Actual table [%s].[%s] is not in table config", new Object[]{dataSource, otherActualTable});
        }
        for (TableRule each2 : this.tableRules) {
            if (!each2.getLogicTable().equals(logicTable.toLowerCase())) continue;
            return each2.getActualDataNodes().get(index).getTableName().toLowerCase();
        }
        throw new ShardingSphereConfigurationException("Cannot find binding actual table, data source: %s, logic table: %s, other actual table: %s", new Object[]{dataSource, logicTable, otherActualTable});
    }

    Collection<String> getAllLogicTables() {
        return this.tableRules.stream().map(input -> input.getLogicTable().toLowerCase()).collect(Collectors.toList());
    }

    Map<String, String> getLogicAndActualTables(String dataSource, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String each : availableLogicBindingTables) {
            String availableLogicTable = each.toLowerCase();
            if (availableLogicTable.equalsIgnoreCase(logicTable) || !this.hasLogicTable(availableLogicTable)) continue;
            result.put(availableLogicTable, this.getBindingActualTable(dataSource, availableLogicTable, actualTable));
        }
        return result;
    }

    @Generated
    public BindingTableRule(List<TableRule> tableRules) {
        this.tableRules = tableRules;
    }

    @Generated
    public List<TableRule> getTableRules() {
        return this.tableRules;
    }
}

