/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rule;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.LoadBalanceStrategyConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.spi.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmServiceLoader;
import org.apache.shardingsphere.spi.masterslave.MasterSlaveLoadBalanceAlgorithm;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;

public class MasterSlaveRule
implements BaseRule {
    private final String name;
    private final String masterDataSourceName;
    private final List<String> slaveDataSourceNames;
    private final MasterSlaveLoadBalanceAlgorithm loadBalanceAlgorithm;
    private final MasterSlaveRuleConfiguration ruleConfiguration;

    public MasterSlaveRule(String name, String masterDataSourceName, List<String> slaveDataSourceNames, MasterSlaveLoadBalanceAlgorithm loadBalanceAlgorithm) {
        this.name = name;
        this.masterDataSourceName = masterDataSourceName;
        this.slaveDataSourceNames = slaveDataSourceNames;
        this.loadBalanceAlgorithm = null == loadBalanceAlgorithm ? (MasterSlaveLoadBalanceAlgorithm)new MasterSlaveLoadBalanceAlgorithmServiceLoader().newService() : loadBalanceAlgorithm;
        this.ruleConfiguration = new MasterSlaveRuleConfiguration(name, masterDataSourceName, slaveDataSourceNames, new LoadBalanceStrategyConfiguration(this.loadBalanceAlgorithm.getType(), this.loadBalanceAlgorithm.getProperties()));
    }

    public MasterSlaveRule(MasterSlaveRuleConfiguration config) {
        this.name = config.getName();
        this.masterDataSourceName = config.getMasterDataSourceName();
        this.slaveDataSourceNames = config.getSlaveDataSourceNames();
        this.loadBalanceAlgorithm = this.createMasterSlaveLoadBalanceAlgorithm(config.getLoadBalanceStrategyConfiguration());
        this.ruleConfiguration = config;
    }

    private MasterSlaveLoadBalanceAlgorithm createMasterSlaveLoadBalanceAlgorithm(LoadBalanceStrategyConfiguration loadBalanceStrategyConfiguration) {
        MasterSlaveLoadBalanceAlgorithmServiceLoader serviceLoader = new MasterSlaveLoadBalanceAlgorithmServiceLoader();
        return null == loadBalanceStrategyConfiguration ? (MasterSlaveLoadBalanceAlgorithm)serviceLoader.newService() : (MasterSlaveLoadBalanceAlgorithm)serviceLoader.newService(loadBalanceStrategyConfiguration.getType(), loadBalanceStrategyConfiguration.getProperties());
    }

    public boolean containDataSourceName(String dataSourceName) {
        return this.masterDataSourceName.equals(dataSourceName) || this.slaveDataSourceNames.contains(dataSourceName);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    @Generated
    public List<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    @Generated
    public MasterSlaveLoadBalanceAlgorithm getLoadBalanceAlgorithm() {
        return this.loadBalanceAlgorithm;
    }

    @Generated
    public MasterSlaveRuleConfiguration getRuleConfiguration() {
        return this.ruleConfiguration;
    }
}

