/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.strategy.keygen;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.core.strategy.keygen.TimeService;
import org.apache.shardingsphere.spi.keygen.ShardingKeyGenerator;

public final class SnowflakeShardingKeyGenerator
implements ShardingKeyGenerator {
    public static final long EPOCH;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final long WORKER_ID_MAX_VALUE = 1024L;
    private static final long WORKER_ID = 0L;
    private static final int DEFAULT_VIBRATION_VALUE = 1;
    private static final int MAX_TOLERATE_TIME_DIFFERENCE_MILLISECONDS = 10;
    private static TimeService timeService;
    private Properties properties = new Properties();
    private int sequenceOffset = -1;
    private long sequence;
    private long lastMilliseconds;

    public String getType() {
        return "SNOWFLAKE";
    }

    public synchronized Comparable<?> generateKey() {
        long currentMilliseconds = timeService.getCurrentMillis();
        if (this.waitTolerateTimeDifferenceIfNeed(currentMilliseconds)) {
            currentMilliseconds = timeService.getCurrentMillis();
        }
        if (this.lastMilliseconds == currentMilliseconds) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (0L == this.sequence) {
                currentMilliseconds = this.waitUntilNextTime(currentMilliseconds);
            }
        } else {
            this.vibrateSequenceOffset();
            this.sequence = this.sequenceOffset;
        }
        this.lastMilliseconds = currentMilliseconds;
        return currentMilliseconds - EPOCH << 22 | this.getWorkerId() << 12 | this.sequence;
    }

    private boolean waitTolerateTimeDifferenceIfNeed(long currentMilliseconds) {
        if (this.lastMilliseconds <= currentMilliseconds) {
            return false;
        }
        long timeDifferenceMilliseconds = this.lastMilliseconds - currentMilliseconds;
        Preconditions.checkState((timeDifferenceMilliseconds < (long)this.getMaxTolerateTimeDifferenceMilliseconds() ? 1 : 0) != 0, (String)"Clock is moving backwards, last time is %d milliseconds, current time is %d milliseconds", (Object[])new Object[]{this.lastMilliseconds, currentMilliseconds});
        Thread.sleep(timeDifferenceMilliseconds);
        return true;
    }

    private long getWorkerId() {
        long result = Long.valueOf(this.properties.getProperty("worker.id", String.valueOf(0L)));
        Preconditions.checkArgument((result >= 0L && result < 1024L ? 1 : 0) != 0);
        return result;
    }

    private int getMaxVibrationOffset() {
        int result = Integer.parseInt(this.properties.getProperty("max.vibration.offset", String.valueOf(1)));
        Preconditions.checkArgument((result >= 0 && (long)result <= 4095L ? 1 : 0) != 0, (Object)"Illegal max vibration offset");
        return result;
    }

    private int getMaxTolerateTimeDifferenceMilliseconds() {
        return Integer.valueOf(this.properties.getProperty("max.tolerate.time.difference.milliseconds", String.valueOf(10)));
    }

    private long waitUntilNextTime(long lastTime) {
        long result = timeService.getCurrentMillis();
        while (result <= lastTime) {
            result = timeService.getCurrentMillis();
        }
        return result;
    }

    private void vibrateSequenceOffset() {
        this.sequenceOffset = this.sequenceOffset >= this.getMaxVibrationOffset() ? 0 : this.sequenceOffset + 1;
    }

    @Generated
    public static void setTimeService(TimeService timeService) {
        SnowflakeShardingKeyGenerator.timeService = timeService;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    static {
        timeService = new TimeService();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 10, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        EPOCH = calendar.getTimeInMillis();
    }
}

