/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.strategy.route.complex;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.api.config.sharding.strategy.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.complex.ComplexKeysShardingValue;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RangeRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;

public final class ComplexShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final ComplexKeysShardingAlgorithm shardingAlgorithm;

    public ComplexShardingStrategy(ComplexShardingStrategyConfiguration complexShardingStrategyConfig) {
        Preconditions.checkNotNull((Object)complexShardingStrategyConfig.getShardingColumns(), (Object)"Sharding columns cannot be null.");
        Preconditions.checkNotNull((Object)complexShardingStrategyConfig.getShardingAlgorithm(), (Object)"Sharding algorithm cannot be null.");
        this.shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.shardingColumns.addAll(Splitter.on((String)",").trimResults().splitToList((CharSequence)complexShardingStrategyConfig.getShardingColumns()));
        this.shardingAlgorithm = complexShardingStrategyConfig.getShardingAlgorithm();
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<RouteValue> shardingValues, ConfigurationProperties properties) {
        HashMap columnShardingValues = new HashMap(shardingValues.size(), 1.0f);
        HashMap columnRangeValues = new HashMap(shardingValues.size(), 1.0f);
        String logicTableName = "";
        for (RouteValue each : shardingValues) {
            if (each instanceof ListRouteValue) {
                columnShardingValues.put(each.getColumnName(), ((ListRouteValue)each).getValues());
            } else if (each instanceof RangeRouteValue) {
                columnRangeValues.put(each.getColumnName(), ((RangeRouteValue)each).getValueRange());
            }
            logicTableName = each.getTableName();
        }
        Collection shardingResult = this.shardingAlgorithm.doSharding(availableTargetNames, new ComplexKeysShardingValue(logicTableName, columnShardingValues, columnRangeValues));
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    @Override
    @Generated
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }
}

