/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.strategy.route.standard;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.shardingsphere.api.config.sharding.strategy.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RangeRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;

public final class StandardShardingStrategy
implements ShardingStrategy {
    private final String shardingColumn;
    private final PreciseShardingAlgorithm preciseShardingAlgorithm;
    private final RangeShardingAlgorithm rangeShardingAlgorithm;

    public StandardShardingStrategy(StandardShardingStrategyConfiguration standardShardingStrategyConfig) {
        Preconditions.checkNotNull((Object)standardShardingStrategyConfig.getShardingColumn(), (Object)"Sharding column cannot be null.");
        Preconditions.checkNotNull((Object)standardShardingStrategyConfig.getPreciseShardingAlgorithm(), (Object)"precise sharding algorithm cannot be null.");
        this.shardingColumn = standardShardingStrategyConfig.getShardingColumn();
        this.preciseShardingAlgorithm = standardShardingStrategyConfig.getPreciseShardingAlgorithm();
        this.rangeShardingAlgorithm = standardShardingStrategyConfig.getRangeShardingAlgorithm();
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<RouteValue> shardingValues, ConfigurationProperties properties) {
        RouteValue shardingValue = shardingValues.iterator().next();
        Collection<String> shardingResult = shardingValue instanceof ListRouteValue ? this.doSharding(availableTargetNames, (ListRouteValue)shardingValue) : this.doSharding(availableTargetNames, (RangeRouteValue)shardingValue);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, RangeRouteValue<?> shardingValue) {
        if (null == this.rangeShardingAlgorithm) {
            throw new UnsupportedOperationException("Cannot find range sharding strategy in sharding rule.");
        }
        return this.rangeShardingAlgorithm.doSharding(availableTargetNames, new RangeShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), shardingValue.getValueRange()));
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, ListRouteValue<?> shardingValue) {
        LinkedList<String> result = new LinkedList<String>();
        for (Comparable each : shardingValue.getValues()) {
            String target = this.preciseShardingAlgorithm.doSharding(availableTargetNames, new PreciseShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), each));
            if (null == target) continue;
            result.add(target);
        }
        return result;
    }

    @Override
    public Collection<String> getShardingColumns() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.add(this.shardingColumn);
        return result;
    }
}

