/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.yaml.swapper;

import com.google.common.base.Strings;
import org.apache.shardingsphere.api.config.masterslave.LoadBalanceStrategyConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.swapper.YamlSwapper;

public final class MasterSlaveRuleConfigurationYamlSwapper
implements YamlSwapper<YamlMasterSlaveRuleConfiguration, MasterSlaveRuleConfiguration> {
    public YamlMasterSlaveRuleConfiguration swap(MasterSlaveRuleConfiguration data) {
        YamlMasterSlaveRuleConfiguration result = new YamlMasterSlaveRuleConfiguration();
        result.setName(data.getName());
        result.setMasterDataSourceName(data.getMasterDataSourceName());
        result.setSlaveDataSourceNames(data.getSlaveDataSourceNames());
        if (null != data.getLoadBalanceStrategyConfiguration()) {
            result.setLoadBalanceAlgorithmType(data.getLoadBalanceStrategyConfiguration().getType());
        }
        return result;
    }

    public MasterSlaveRuleConfiguration swap(YamlMasterSlaveRuleConfiguration yamlConfiguration) {
        return new MasterSlaveRuleConfiguration(yamlConfiguration.getName(), yamlConfiguration.getMasterDataSourceName(), yamlConfiguration.getSlaveDataSourceNames(), this.getLoadBalanceStrategyConfiguration(yamlConfiguration));
    }

    private LoadBalanceStrategyConfiguration getLoadBalanceStrategyConfiguration(YamlMasterSlaveRuleConfiguration yamlConfiguration) {
        return Strings.isNullOrEmpty((String)yamlConfiguration.getLoadBalanceAlgorithmType()) ? null : new LoadBalanceStrategyConfiguration(yamlConfiguration.getLoadBalanceAlgorithmType(), yamlConfiguration.getProps());
    }
}

